<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoGrant\MoGrantTypes;

use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoGrant\MoUnoGrantsAbstract;
use Drupal\miniorange_oauth_client\MoHelper\MoUtilities;

class MoUnoAuthorizationCodeGrant extends MoUnoGrantsAbstract
{
  public function readGrant(array &$grants): void
  {
    $grants['authorization_code'] = 'Authorization Code';
  }

  /**
   * Parent method to add Authentication methods to the grant types so this helps to build the options
   * based on the grant type if you need to add some additional options to it extend it in you child class and
   * overwrite the method
   *
   * @param array $options the base options for mapping the authorization grant methods
   *
   * @return void
   */
  public function getAuthenticationMethodOptions(array &$options): void
  {
    $options['values_in_header'] = 'Authorization Header';
    $options['values_in_body'] = 'Request Body';
  }


  /**
   * @throws \Exception
   */
  public function buildTokenRequest(MoClientConfiguration $client_config, array $headers, ?string $code = '', ?array $query_params = []): array
  {
    parent::validateCode($code, $query_params);
    parent::readConfigCredentials($client_config);

    $url_params['redirect_uri'] = $this->callback_url;
    $url_params['code'] = $code;
    $url_params['grant_type'] = 'authorization_code';

    parent::addCredentialsInRequest($url_params, $headers);


    return [$headers, $url_params];
  }

  public function buildAuthorizationUrl(MoClientConfiguration $client_config, string $state): string
  {
    $query_params = [
      'client_id' => $client_config->getClientId(),
      'scope' => str_replace('+', ' ', $client_config->getScope()),
      'redirect_uri' => MoUtilities::getCallbackUrl($client_config->id()),
      'response_type' => 'code',
      'state' => $state
    ];
    return Url::fromUri($client_config->getAuthorizeEndpoint(), ['query' => $query_params])->toString();
  }
}
