<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoGrant;

use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoGrant\MoGrantTypes\MoUnoAuthorizationCodeGrant;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoClientConfiguration\MoGrant\MoStdReadGrants as MoStandardGrants;
use Drupal\miniorange_oauth_client\MoHelper\MoUtilities;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoReadGrants
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function getGrantTypes(array &$grants = []): void
  {
    $this->call([MoUnoAuthorizationCodeGrant::class, 'readGrant'], ['grants' => &$grants]);
    $this->call([MoStandardGrants::class, 'getGrantTypes'], ['grants' => &$grants]);
  }

  /**
   * @throws \Exception
   */
  public function getAuthenticationMethodOptions(array &$options = []): void
  {
    $this->call([MoUnoAuthorizationCodeGrant::class, 'getAuthenticationMethodOptions'], ['options' => &$options]) ?? [];
    $this->call([MoStandardGrants::class, 'getAuthenticationMethodOptions'], ['options' => &$options]);
  }

  public function buildAuthorizationUrl(MoClientConfiguration $client_config, string $state): ?string
  {
    if ($client_config->getGrantType() == 'authorization_code') {
      return $this->call(
        [MoUnoAuthorizationCodeGrant::class, 'buildAuthorizationUrl'], ['client_config' => $client_config, 'state' => $state]
      );
    }
    return $this->call([MoStandardGrants::class, 'buildAuthorizationUrl'], ['client_config' => $client_config, 'state' => $state]);
  }

  /**
   * @throws \Exception
   */
  public function gatherTokenFromIDP(MoClientConfiguration $client_config, ?string $code = '', array $query_params = [])
  {
    $grant_type = $client_config->getGrantType();
    if ($grant_type == 'implicit') {
      return $this->call(
        [MoStandardGrants::class, 'gatherTokenFromIDP'],
        ['client_config' => $client_config, 'code' => $code, 'query_params' => $query_params]
      );
    } else {
      $headers = [
        'Accept' => 'application/json',
        'Content-Type' => 'application/x-www-form-urlencoded',
      ];
      [$headers, $url_params] = match ($grant_type) {
        'authorization_code' => $this->call(
          [MoUnoAuthorizationCodeGrant::class, 'buildTokenRequest'],
          ['client_config' => $client_config, 'headers' => $headers, 'code' => $code, 'query_params' => $query_params],
        ),
        'authorization_code_with_pkce', 'password', 'refresh_token' => $this->call(
          [MoStandardGrants::class, 'gatherTokenFromIDP'],
          ['client_config' => $client_config, 'code' => $code, 'query_params' => $query_params, 'headers' => $headers],
        ),
      };

      if (empty($headers) || empty($url_params)) {
        throw new \Exception("The params to perform Token call is empty.");
      }
      return MoUtilities::buildPostRequest($headers, $url_params, $client_config->getAccessTokenEndpoint());
    }
  }

  /**
   * @throws \Exception
   */
  public function initiatePasswordGrandAuthorizationCall(FormStateInterface $form_state): void
  {
    $this->call([MoStandardGrants::class, 'initiatePasswordGrandAuthorizationCall'], ['form_state' => $form_state]);
  }
}
