<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations;

use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoOperations\MoStdAttributeMapping as MoStandardAttributeMapping;
use Drupal\miniorange_oauth_client\Entity\MoAttributeMapping as MoAttributeMappingEntity;
use Drupal\user\Entity\User;

class MoUnoAttributeMapping
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function getUserEmail(?array $resource_owner, ?string $client_id): ?string
  {
    $email_attribute = $this->getUserEmailAttribute($client_id);
    $email_attribute !== '' || throw new \Exception("User Email attribute is not configured in the Attributes Mapping section.");
    return !empty($resource_owner[$email_attribute]) ?
      $resource_owner[$email_attribute] :
      throw new \Exception("User Email attribute not found.");
  }

  /**
   * Read user email attribute
   *
   * @param string|null $id Attribute mapping id
   *
   * @return string|null
   */
  public function getUserEmailAttribute(?string $id): ?string
  {
    return MoAttributeMappingEntity::readMe($id)->getEmailAttribute();
  }

  /**
   * @throws \Exception
   */
  public function mapCustomAttributes(User &$user, string $client_id, array $resource_owner): void
  {
    $this->call(
      [MoStandardAttributeMapping::class, 'mapCustomAttributes'],
      ['user' => &$user, 'client_id' => $client_id, 'resource_owner' => $resource_owner]
    );
  }
}
