<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations;

use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoOperations\MoStdClientSettings;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoClientSettings
{
  use MoGhostInvoker;

  public function tieTokenExpiryToUserSession(?array $user_token, ?string $client_id)
  {
    $this->call([MoStdClientSettings::class, 'tieTokenExpiryToUserSession'], ['user_token' => $user_token, 'client_id' => $client_id]);
  }

  public function validateUserSession(): void
  {
    $this->call([MoStdClientSettings::class, 'validateUserSession']);
  }
}
