<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations;

use Drupal\Core\Entity\EntityStorageException;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\user\Entity\User;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoOperations\MoStdRoleMapping;

class MoUnoRoleMapping
{
  use MoGhostInvoker;
  /**
   * @throws \Exception
   */
  public function mapDefaultUserRole(User &$user, string $client_id): void
  {
    $this->call(
      [MoStdRoleMapping::class, 'mapDefaultUserRole'],
      ['user' => &$user, 'client_id' => $client_id]
    );
  }

  /**
   * @throws EntityStorageException|\Exception
   */
  public function mapCustomUserRoles(User &$user, string $client_id, array $resource_owner): void
  {
    $this->call(
      [MoStdRoleMapping::class, 'mapCustomUserRoles'],
      ['user' => &$user, 'client_id' => $client_id, 'resource_owner' => $resource_owner]
    );
  }
}
