<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures;

use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoStdLicenseRouteBuilder;

class MoUnoLicenseRouteBuilder
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function buildRoute(RouteCollection $collection): void
  {

    // this piece is written here to bring the base route stating towards links.task.yml
    // we will remove this from the menus in MoReplaceYML/MoUnoModuleTabs.php file
    $license_registration = new Route(
      '/admin/config/people/mo-oauth-client/customer-config',
      [
        '_form' => '\Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoLicense\Form\MoStdCustomerConfigurationForm',
        '_title_callback' => '\Drupal\miniorange_oauth_client\Controller\MoModuleController::customizeRouteTitle'
      ],
      [
        '_permission' => 'mo_administrator',
      ]
    );

    $collection->add('mo_license.customer_config', $license_registration);

    $this->call([MoStdLicenseRouteBuilder::class, 'buildRoute'], ['collection' => $collection]);
  }
}
