<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures;

use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoStdLicenseTierManager;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoLicenseTierManager
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function getLicenseVersion(): string
  {
    return $this->call([MoStdLicenseTierManager::class, 'getLicenseVersion']) ?? MoModuleConstant::MO_FREE_VERSION;
  }

  /**
   * @throws \Exception
   */
  public function getModulePlanTier()
  {
    return $this->call([MoStdLicenseTierManager::class, 'getModulePlanTier']) ?? MoModuleConstant::MO_FREE_PLAN_NAME;
  }

  /**
   * @throws \Exception
   */
  public function validateModuleLicense() {
    return $this->call([MoStdLicenseTierManager::class, 'validateModuleLicense']);
  }

  /**
   * @throws \Exception
   */
  public function getModuleVersion()
  {
    return $this->call([MoStdLicenseTierManager::class, 'getModuleVersion']) ??
      (
        \Drupal::service('extension.list.module')->getExtensionInfo(MoModuleConstant::MODULE_NAME)['version'] ??
        MoModuleConstant::MO_UNO_MODULE_VERSION
      );
  }
}
