<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoHooks\MoUnoHooksLoader;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoGrant\MoUnoReadGrants;

class MoUnoLoginFormModifier
{
  use MoGhostInvoker;
  public function alterUserLoginForm(array &$form, FormStateInterface $form_state): void
  {
    // Verify the module license before add the components to the UI
    if (
      !\Drupal::service('miniorange_oauth_client.uno_module_subscription_library')->getModuleStatus()
    ) {
      \Drupal::service('page_cache_kill_switch')->trigger();
      $module_handler = \Drupal::moduleHandler();
      foreach (MoClientConfiguration::loadActive(false, true) as $config) {
        $display_name = !empty($config->getLoginLinkText()) ? $config->getLoginLinkText() : 'Log-in using ' . $config->id();
        $login_url = Url::fromRoute('mo_oauth.authorization_request', ['mo_client_config' => $config->id()], ['absolute' => TRUE]);

        $this->call(
          [MoUnoHooksLoader::class, 'modifyLoginLink'],
          [
            'module_handler' => $module_handler,
            'form' => &$form,
            'config_id' => $config->id(),
            'login_url' => $login_url,
            'display_name' => $display_name
          ]
        );
        if (!$module_handler->hasImplementations('mo_login_link_modify')) {
          $form['add_mo_client_' . $config->id()] = [
            '#type' => 'link',
            '#suffix' => '<br>',
            '#title' => t($display_name),
            '#url' => $login_url,
          ];
        }
      }
      if (!empty($grants = MoClientConfiguration::loadPasswordGrants())) {
        array_unshift($form['#validate'], [$this, 'passwordGrantSubmit']);
        $form_state->set('mo_password_grant', reset($grants));
      }
    }
  }

  /**
   * Add a validation method on the user login form submit in case of password grant is enabled
   *
   * @param array $form array of form elements
   * @param FormStateInterface $form_state form state object
   *
   * @return void
   * @throws \Exception
   */
  function passwordGrantSubmit(array &$form, FormStateInterface $form_state): void
  {
    $this->call([MoUnoReadGrants::class, 'initiatePasswordGrandAuthorizationCall'], ['form_state' => $form_state]);
  }
}
