<?php

/**
 * This file provides functionalities that helps with building some UI and some other basic functionalities for
 * configuring the Identity Provider in the module.
 *
 * @author MiniOrange
 * @version 1.0
 */
namespace Drupal\miniorange_oauth_client\MoHelper;

class MoClientConfigurationHelper
{

  /**
   * Get list of available Identity Providers
   *
   * @return array
   */
  public static function getIdentityProviders(): array
  {
    return [
      'AWS Cognito' => t('AWS Cognito'),
      'Azure AD' => t('Microsoft Entra ID(Azure AD)'),
      'Azure AD B2C' => t('Azure AD B2C'),
      'Box' => t('Box'),
      'Discord' => t('Discord'),
      'Facebook' => t('Facebook'),
      'FitBit' => t('FitBit'),
      'Github' => t('Github'),
      'Google' => t('Google'),
      'Keycloak' => t('Keycloak'),
      'Line' => t('Line'),
      'LinkedIn' => t('LinkedIn'),
      'miniOrange' => t('miniOrange'),
      'Okta' => t('Okta'),
      'Onelogin' => t('Onelogin'),
      'Salesforce' => t('Salesforce'),
      'Slack' => t('Slack'),
      'Strava' => t('Strava'),
      'WHMCS' => t('WHMCS'),
      'Wild Apricot' => t('Wild Apricot'),
      'Zendesk' => t('Zendesk'),
      'Custom_OAuth' => t('Custom OpenID/OAuth 2.0 Provider')
    ];
  }

  /**
   * todo need to add css for this part
   *
   * Build markup to define attribute mapping in the client configuration tab
   *
   * @return string[]
   */
  public static final function getAttributeMappingMarkup(): array
  {
    return [
      '#type' => 'container',
      '#attributes' => [
        'class' => [
          'mo-oauth-highlight-note'
        ]
      ],
      'note_title' => [
        '#markup' => '<strong class="mo-strong mo-red mo-space-right">' . t('Please Note:') . '</strong>',
      ],
      'note_body' => [
        '#markup' => '<em class="mo-space">'.
          t('Attribute Mapping is mandatory for login. Once the Test connection is successful,
        please navigate to the "Attribute Mapping" tab, select the Email Attribute, and save the configuration.').
        '</em>',

      ],
      '#prefix' => '<br>',
      '#suffix' => '<br>',
    ];


  }

  /**
   * The below function helps in masking the client secret
   *
   * @param string|null $secret client secret value
   *
   * @return string
   */
  public static final function maskClientSecret(?string $secret): string
  {
    if (empty($secret)) {
      return '';
    }
    $maskedLength = strlen($secret) < 1 ? 1 : strlen($secret) - 6;
    return substr($secret, 0, 3) . str_repeat('*', $maskedLength * 2) . substr($secret, -3);
  }

}
