<?php

/**
 * This file contains a list of functions that helps in case of any issue arises while fetching info from external endpoints.
 */
namespace Drupal\miniorange_oauth_client\MoHelper;

class MoFallBackSupport
{
  /**
   * This function has a predefined configuration details of all idp this helps in the fallback scenario
   *
   * @param string|null $column_name column name to search the match
   * @param string|null $provider_name provider name for fetching info
   *
   * @return array
   */
  public static function idpInfoHelper(?string $column_name = null, ?string $provider_name = null): array
  {
    $providers = [
        [
          'id' => 'oauth2',
          'clientName' => 'Custom OAuth 2.0 App',
          'scope' => '',
          'authorizationEndpoint' => '',
          'tokenEndpoint' => '',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'openid-connect',
          'clientName' => 'Custom OIDC App',
          'scope' => '',
          'authorizationEndpoint' => '',
          'tokenEndpoint' => '',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'google',
          'clientName' => 'Google',
          'scope' => 'email+profile',
          'authorizationEndpoint' => 'https://accounts.google.com/o/oauth2/auth',
          'tokenEndpoint' => 'https://www.googleapis.com/oauth2/v4/token',
          'userInfoEndpoint' => 'https://www.googleapis.com/oauth2/v1/userinfo',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/google-apps-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=9WgyzY1paAA'
        ],
        [
          'id' => 'azure',
          'clientName' => 'Azure AD',
          'scope' => 'openid',
          'authorizationEndpoint' => 'https://login.microsoftonline.com/{tenant-ID}/oauth2/v2.0/authorize',
          'tokenEndpoint' => 'https://login.microsoftonline.com/{tenant-ID}/oauth2/v2.0/token',
          'userInfoEndpoint' => 'https://graph.microsoft.com/oidc/userinfo',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/microsoft-entra-id-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=kwEQWXwOyPI'
        ],
        [
          'id' => 'azure',
          'clientName' => 'Azure AD B2C',
          'scope' => 'openid',
          'authorizationEndpoint' => 'https://{tenant-name}.b2clogin.com/{tenant-name}.onmicrosoft.com/{policy-name}/oauth2/v2.0/authorize',
          'tokenEndpoint' => 'https://{tenant-name}.b2clogin.com/{tenant-name}.onmicrosoft.com/{policy-name}/oauth2/v2.0/token',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/azure-b2c-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'cognito',
          'clientName' => 'AWS Cognito',
          'scope' => 'openid',
          'authorizationEndpoint' => 'https://{cognito-app-domain}/oauth2/authorize',
          'tokenEndpoint' => 'https://{cognito-app-domain}/oauth2/token',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/aws-cognito-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'miniorange',
          'clientName' => 'miniOrange',
          'scope' => 'email profile openid',
          'authorizationEndpoint' => 'https://login.xecurify.com/moas/idp/openidsso',
          'tokenEndpoint' => 'https://login.xecurify.com/moas/rest/oauth/token',
          'userInfoEndpoint' => 'https://login.xecurify.com/moas/rest/oauth/getuserinfo',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'onelogin',
          'clientName' => 'Onelogin',
          'scope' => 'openid',
          'authorizationEndpoint' => 'https://fitzola.onelogin.com/oidc/2/auth',
          'tokenEndpoint' => 'https://fitzola.onelogin.com/oidc/2/token',
          'userInfoEndpoint' => 'https://fitzola.onelogin.com/oidc/2/me',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/onelogin-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'facebook',
          'clientName' => 'Facebook',
          'scope' => 'email',
          'authorizationEndpoint' => 'https://www.facebook.com/dialog/oauth',
          'tokenEndpoint' => 'https://graph.facebook.com/v2.8/oauth/access_token',
          'userInfoEndpoint' => 'https://graph.facebook.com/me/?fields=id,name,email,age_range,first_name,gender,last_name,link&access_token=',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/facebook-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ZIYefJDduvs'
        ],
        [
          'id' => 'linkedin',
          'clientName' => 'LinkedIn',
          'scope' => 'openid profile email',
          'authorizationEndpoint' => 'https://www.linkedin.com/oauth/v2/authorization',
          'tokenEndpoint' => 'https://www.linkedin.com/oauth/v2/accessToken',
          'userInfoEndpoint' => 'https://api.linkedin.com/v2/me',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/contributed-modules/drupal-oauth-oidc-login/linkedin-sso-login',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=YRqfTPxezMU'
        ],
        [
          'id' => 'salesforce',
          'clientName' => 'Salesforce',
          'scope' => 'id',
          'authorizationEndpoint' => 'https://login.salesforce.com/services/oauth2/authorize',
          'tokenEndpoint' => 'https://login.salesforce.com/services/oauth2/token',
          'userInfoEndpoint' => 'https://login.salesforce.com/services/oauth2/userinfo',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/salesforce-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=3QRHEIoLzYw'
        ],
        [
          'id' => 'wildApricot',
          'clientName' => 'Wild Apricot',
          'scope' => 'auto',
          'authorizationEndpoint' => 'https://{your_account_url}/sys/login/OAuthLogin',
          'tokenEndpoint' => 'https://oauth.wildapricot.org/auth/token',
          'userInfoEndpoint' => 'https://api.wildapricot.org/v2.1/accounts/{account_id}/contacts/me',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/contributed-modules/drupal-oauth-oidc-login/wild-apricot-sso-login',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=jT5yVQe8txg'
        ],
        [
          'id' => 'keycloak',
          'clientName' => 'Keycloak',
          'scope' => 'openid email profile',
          'authorizationEndpoint' => '{Keycloak_base_URL}/realms/{realm-name}/protocol/openid-connect/auth',
          'tokenEndpoint' => '{Keycloak_base_URL}/realms/{realm-name}/protocol/openid-connect/token',
          'userInfoEndpoint' => '{Keycloak_base_URL}/realms/{realm-name}/protocol/openid-connect/userinfo',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/keycloak-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=QcJuH4jdX4U'
        ],
        [
          'id' => 'strava',
          'clientName' => 'Strava',
          'scope' => 'public',
          'authorizationEndpoint' => 'https://www.strava.com/oauth/authorize',
          'tokenEndpoint' => 'https://www.strava.com/oauth/token',
          'userInfoEndpoint' => 'https://www.strava.com/api/v3/athlete',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/contributed-modules/drupal-oauth-oidc-login/strava-sso-login',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=V0JAi_zfKy8'
        ],
        [
          'id' => 'fitbit',
          'clientName' => 'FitBit',
          'scope' => 'profile',
          'authorizationEndpoint' => 'https://www.fitbit.com/oauth2/authorize',
          'tokenEndpoint' => 'https://api.fitbit.com/oauth2/token',
          'userInfoEndpoint' => 'https://api.fitbit.com/1/user/-/profile.json',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'discord',
          'clientName' => 'Discord',
          'scope' => 'identify email',
          'authorizationEndpoint' => 'https://discordapp.com/api/oauth2/authorize',
          'tokenEndpoint' => 'https://discordapp.com/api/oauth2/token',
          'userInfoEndpoint' => 'https://discordapp.com/api/users/@me',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/discord-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=RQq79fglSC8'
        ],
        [
          'id' => 'line',
          'clientName' => 'Line',
          'scope' => 'Profile openid email',
          'authorizationEndpoint' => 'https://access.line.me/oauth2/v2.1/authorize',
          'tokenEndpoint' => 'https://api.line.me/oauth2/v2.1/token',
          'userInfoEndpoint' => 'https://api.line.me/v2/profile',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'whmcs',
          'clientName' => 'WHMCS',
          'scope' => 'openid profile email',
          'authorizationEndpoint' => 'https://{yourWHMCSdomain}/oauth/authorize.php',
          'tokenEndpoint' => 'https://{yourWHMCSdomain}/oauth/token.php',
          'userInfoEndpoint' => 'https://{yourWHMCSdomain}/oauth/userinfo.php?access_token=',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/whmcs-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'zendesk',
          'clientName' => 'Zendesk',
          'scope' => 'read write',
          'authorizationEndpoint' => 'https://{subdomain}.zendesk.com/oauth/authorizations/new',
          'tokenEndpoint' => 'https://{subdomain}.zendesk.com/oauth/tokens',
          'userInfoEndpoint' => 'https://{subdomain}.zendesk.com/api/v2/users',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/contributed-modules/drupal-oauth-oidc-login/zendesk-sso-login',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'box',
          'clientName' => 'Box',
          'scope' => 'root_readwrite',
          'authorizationEndpoint' => 'https://account.box.com/api/oauth2/authorize',
          'tokenEndpoint' => 'https://api.box.com/oauth2/token',
          'userInfoEndpoint' => 'https://api.box.com/2.0/users/me',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'github',
          'clientName' => 'Github',
          'scope' => 'user repo',
          'authorizationEndpoint' => 'https://github.com/login/oauth/authorize',
          'tokenEndpoint' => 'https://github.com/login/oauth/access_token',
          'userInfoEndpoint' => 'https://api.github.com/user',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/github-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=FzGH3EMnwws&feature=youtu.be'
        ],
        [
          'id' => 'slack',
          'clientName' => 'Slack',
          'scope' => 'users.profile:read',
          'authorizationEndpoint' => 'https://slack.com/oauth/authorize',
          'tokenEndpoint' => 'https://slack.com/api/oauth.access',
          'userInfoEndpoint' => 'https://slack.com/api/users.profile.get',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/contributed-modules/drupal-oauth-oidc-login/slack-sso-login',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=9QQBkwuALUA'
        ],
        [
          'id' => 'okta',
          'clientName' => 'Okta',
          'scope' => 'openid email profile',
          'authorizationEndpoint' => 'https://{yourOktaDomain}.com/oauth2/v1/authorize',
          'tokenEndpoint' => 'https://{yourOktaDomain}.com/oauth2/v1/token',
          'userInfoEndpoint' => 'https://{yourOktaDomain}.com/oauth2/v1/userinfo',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/okta-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ly1Zsv1qsAI'
        ],
        [
          'id' => 'auth0',
          'clientName' => 'Auth0',
          'scope' => '',
          'authorizationEndpoint' => '',
          'tokenEndpoint' => '',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'office365',
          'clientName' => 'Office 365',
          'scope' => '',
          'authorizationEndpoint' => '',
          'tokenEndpoint' => '',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/oauth-openid-connect-login-oauth2-client-sso-login/office-365-oauth-sso-setup',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'reddit',
          'clientName' => 'Reddit',
          'scope' => '',
          'authorizationEndpoint' => '',
          'tokenEndpoint' => '',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [
          'id' => 'apple',
          'clientName' => 'Apple',
          'scope' => '',
          'authorizationEndpoint' => '',
          'tokenEndpoint' => '',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ],
        [ 
          'id' => 'diaspora',
          'clientName' => 'Diaspora',
          'scope' => '',
          'authorizationEndpoint' => '',
          'tokenEndpoint' => '',
          'userInfoEndpoint' => '',
          'jwksEndpoint' => '',
          'groupInfoEndpoint' => '',
          'SLOEndpoint' => '',
          'SLOParam' => '',
          'setupGuideLink' => 'https://plugins.miniorange.com/how-to-setup-drupal-oauth-client-sso',
          'videoGuideLink' => 'https://www.youtube.com/watch?v=ipjiRfzpH8Y'
        ]
      ];
    return $provider_name ?
      (is_int($index = array_search($provider_name, array_column($providers, $column_name))) ? $providers[$index] : []) :
      $providers;
  }

  public static function getClientConfigEndpoints(?string $provider_name) {
    $index = array_search($provider_name, array_column(self::idpInfoHelper(), 'clientName'));

    return $index === false ? [] : self::idpInfoHelper()[$index];
  }
}
