<?php

namespace Drupal\miniorange_saml\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_saml\MiniorangeSamlConstant;
use Drupal\Core\Render\Markup;
use Drupal\Core\Url;

/**
 * Provides a form for the miniorange_saml licensing.
 */
class MiniorangeLicensing extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'miniorange_saml_licensing';
  }

  /**
   * Builds the miniorange_saml licensing form.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param array|null $options
   *   Additional options for form building.
   *
   * @return array
   *   The form array
   */
  public function buildForm(array $form, FormStateInterface $form_state, $options = NULL) {
    global $base_url;
        $module_path = $base_url . '/' . \Drupal::service('extension.list.module')->getPath("miniorange_saml");
        $module_data = \Drupal::service('extension.list.module')->getExtensionInfo('miniorange_saml');
    $features = [
      [
          'title' => 'Authentication with Multiple IDPs',
          'description' => 'Allow users to log in using multiple Identity Providers seamlessly.',
      ],
      [
          'title' => 'Advance Attribute & Role Mapping',
          'description' => 'Map user attributes and roles from the IdP to Drupal automatically.',
      ],
      [
          'title' => 'SAML Single Logout',
          'description' => 'Log out from all connected applications with one unified action.',
      ],
      [
          'title' => 'Auto-sync IdP metadata',
          'description' => 'Keep your configuration updated by automatically syncing IdP metadata.',
      ],
      [
          'title' => 'Force Authentication with IDP',
          'description' => 'Require users to authenticate with the IdP every time they log in.',
      ],
      [
          'title' => 'Redirection to a custom page after login',
          'description' => 'Redirect users to a specific page after successful authentication.',
      ],

    ];


    $related_products = [
       [
          'title' => 'Drupal User Provisioning & Sync (SCIM)',
          'description' => 'The Drupal User Provisioning and Sync module automates the creation, updating, and removal of user accounts across systems. It seamlessly syncs user roles and groups between the identity provider and your Drupal site, ensuring consistent access control and efficient user management.',
          'image' => 'UserProvisioning.webp',
          'link' => 'https://plugins.miniorange.com/drupal-user-provisioning-and-sync'
      ],
      [
          'title' => 'Two Factor Authentication',
          'description' => 'Second-Factor Authentication (TFA) adds a second layer of security with an option to configure truly Passwordless Login. You can configure the module to send an OTP to your preferred mode of communication like phone/email, integrate with TOTP Apps like Google Authenticator or configure hardware token 2FA method.',
          'image' => '2FA.webp',
          'link' => 'https://plugins.miniorange.com/drupal-two-factor-authentication-2fa'
      ],
      [
          'title' => 'OTP Verification',
          'description' => 'Drupal OTP Verification module verifies Email Address/Mobile Number of users by sending verification code(OTP) during registration. It eliminates the possibility of a user registering with invalid personal details (phone number or email) on the Drupal site.',
          'image' => 'OTP.webp',
          'link' => 'https://plugins.miniorange.com/drupal-otp-verification'
      ],
      [
          'title' => 'REST API Authentication',
          'description' => 'Drupal REST & JSON API Authentication module secures your Drupal site APIs against unauthorized access by enforcing different authentication methods including Basic Authentication, API Key Authentication, JWT Authentication, Third-Party Provider Authentication, etc.',
          'image' => 'REST-API.webp',
          'link' => 'https://plugins.miniorange.com/drupal-rest-api-authentication'
      ],
      [
          'title' => 'Session Management',
          'description' => 'User Session Management module helps you to manage the Drupal user session-related operations. It efficiently handles user sessions and provides you with multiple features like terminating any user session from the admin section, auto-logout user on being idle for the configured amount of time, limiting the number of simultaneous sessions per user, IP-based login restrictions, and many more.',
          'image' => 'Session-Management.webp',
          'link' => 'https://plugins.miniorange.com/drupal-session-management'
      ],
      [
          'title' => 'Website Security Pro',
          'description' => 'The Website Security Pro module safeguards your Drupal site with enterprise-grade security. It protects against brute force and DDoS attacks, enforces strong passwords, monitors and blacklists suspicious IPs, and secures login and registration forms. Designed to block hackers and malware, it ensures your site stays secure, stable, and reliable.',
          'image' => 'Web-Security.webp',
          'link' => 'https://plugins.miniorange.com/drupal-web-security-pro',
      ],
      ];

        $form['markup_library'] = array(
            '#attached' => array(
                'library' => array(
                    "miniorange_saml/miniorange_saml.admin"
                )
            )
        );

    
        $form['current_plan_section'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['current-plan-section']
            ],
        ];
        $form['current_plan_section']['plan_info'] = [
            '#type' => 'container',
            '#attributes' => ['class' => ['plan-info']],
        ];

        $form['current_plan_section']['plan_info']['plan_type'] = [
            '#type' => 'markup',
            '#markup' => 'Current Plan: Free Version',
        ];

        $form['current_plan_section']['plan_info']['module_info'] = [
            '#type' => 'markup',
            '#markup' => Markup::create('<h3>SAML SP</h3>'),
            '#attributes' => ['class' => ['module-info']],
        ];
        
        $form['current_plan_section']['plan_info']['version_info'] = [
            '#type' => 'markup',
            '#markup' => 'Version: ' .$module_data['version'], 
        ];

        // Right side upgrade button
        $form['current_plan_section']['upgrade_button'] = [
            '#type' => 'link',
            '#title' => t('Upgrade Plan'),
            '#url' => Url::fromUri('https://plugins.miniorange.com/drupal-saml-single-sign-on-sso'),
            '#attributes' => [
                'class' => ['button', 'button--primary'],
                '#target' => '_blank',
            ],
        ];

        // Premium Features Section
        $form['premium_features_section'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['section-container'],
            ],
        ];

        $form['premium_features_section']['title'] = [
            '#type' => 'markup',
            '#markup' => '<h3>Premium Features</h3>',
            '#prefix' => '<div class="section-title">',
        ];

        $form['premium_features_section']['upgrade-button'] = [
            '#type' => 'link',
            '#title' => t('View All Features'),
            '#url' => Url::fromUri('https://plugins.miniorange.com/drupal-saml-single-sign-on-sso'),
            '#attributes' => [
                'class' => ['button', 'button--primary'],
                'target' => '_blank',
            ],
            '#suffix' => '</div>',
        ];

        // Features Grid Container
        $form['premium_features_section']['features_grid'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['features-grid'],
            ],
        ];

        foreach ($features as $index => $feature) {
            $form['premium_features_section']['features_grid']['feature_' . $index] = [
                '#type' => 'container',
                '#attributes' => [
                    'class' => ['feature-box']
                ],
            ];

            $form['premium_features_section']['features_grid']['feature_' . $index]['content'] = [
                '#type' => 'markup',
                '#markup' => '<h5>' . $feature['title'] . '</h5>' . $feature['description'],
            ];
        }

        // Related Products Section
        $form['related_products_section'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['section-container'],
            ],
        ];

        $form['related_products_section']['title'] = [
            '#type' => 'markup',
            '#markup' => '<h3>Related Products</h3>',
            '#prefix' => '<div class="section-title">',
        ];

        $form['related_products_section']['upgrade-button'] = [
            '#type' => 'link',
            '#title' => t('View All Products'),
            '#url' => Url::fromUri('https://plugins.miniorange.com/drupal'),
            '#attributes' => [
                'class' => ['button', 'button--primary'],
                'target' => '_blank',
            ],
            '#suffix' => '</div>',
        ];

        // Features Grid Container
        $form['related_products_section']['features_grid'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['features-grid']
            ],
        ];

        // Feature boxes with images

        foreach ($related_products as $index => $product) {
            $form['related_products_section']['features_grid']['feature_' . $index] = [
                '#type' => 'container',
                '#attributes' => [
                    'class' => ['feature-box']
                ],
            ];

            $form['related_products_section']['features_grid']['feature_' . $index]['title'] = [
                '#type' => 'markup',
                '#markup' => '<h5>' . $product['title'] . '</h5><hr>',
            ];

            // Image
            $form['related_products_section']['features_grid']['feature_' . $index]['image'] = [
                '#type' => 'markup',
                '#markup' => $this->t('<div><img class="feature-image" src=":module_path/includes/images/:image" alt=":title"></div>', [
                    ':module_path' => $module_path,
                    ':image' => $product['image'],
                    ':title' => $product['title'],
                ]),
            ];

            // Title and Description
            $form['related_products_section']['features_grid']['feature_' . $index]['content'] = [
                '#type' => 'markup',
                '#markup' => '<span class="product-description">' . $product['description'] . '</span>',
            ];

            // View Details Button
            $form['related_products_section']['features_grid']['feature_' . $index]['button'] = [
                '#type' => 'link',
                '#title' => t('View Details'),
                '#url' => Url::fromUri($product['link']),
                '#attributes' => [
                    'class' => ['button', 'button--primary'],
                    'style' => 'margin-top: 10px;',
                ],
                '#target' => '_blank',
            ];
        }


    $rows = [
      [
        Markup::create(t('<b>1.</b> Click on Upgrade Now button for required licensed plan and you will be redirected to miniOrange login console.</li>')),
        Markup::create(t('<b>5.</b> Uninstall and then delete the free version of the module from your Drupal site.')),
      ],
      [
        Markup::create(t('<b>2.</b> Enter your username and password with which you have created an account with us. After that you will be redirected to payment page.')),
        Markup::create(t('<b>6.</b> Now install the downloaded licensed version of the module.')),
      ],
      [
        Markup::create(t('<b>3.</b> Enter your card details and proceed for payment. On successful payment completion, the Licensed version module(s) will be available to download.')),
        Markup::create(t('<b>7.</b> Clear Drupal Cache from <a href="@base_url" >here</a>.', ['@base_url' => $base_url . '/admin/config/development/performance'])),
      ],
      [
        Markup::create(t('<b>4.</b> Download the licensed module(s) from Module Releases and Downloads section.')),
        Markup::create(t('<b>8.</b> After enabling the licensed version of the module, login using the account you have registered with us.')),
      ],
    ];

    $form['markup_how to upgrade'] = [
      '#markup' => '<h3 class="mo_saml_text_center">How to Upgrade to Licensed Version Module</h3>',
    ];

    $form['miniorange_how_to_upgrade_table'] = [
      '#type' => 'table',
      '#responsive' => TRUE,
      '#rows' => $rows,
      '#attributes' => ['style' => 'border:groove', 'class' => ['mo_how_to_upgrade']],
    ];

    return $form;

  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
  }

}
