/**
 * @file
 * JavaScript for expanding/collapsing the comparison table.
 */

(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.moSamlComparisonToggle = {
    attach: function (context, settings) {
      var $toggleLink = $('#mo-saml-view-full-comparison', context);
      var $comparisonTable = $('.mo-saml-comparison-table', context);
      var isExpanded = false;
      var originalText = $toggleLink.text();

      // Prevent default link behavior
      $toggleLink.on('click', function (e) {
        e.preventDefault();
        
        if (!isExpanded) {
          // Expand the table
          $comparisonTable.addClass('expanded');
          $toggleLink.text('Hide Features');
          isExpanded = true;
        } else {
          // Collapse the table
          $comparisonTable.removeClass('expanded');
          $toggleLink.text(originalText);
          isExpanded = false;
          
          // Scroll to top of comparison section
          $('html, body').animate({
            scrollTop: $('.mo-saml-comparison-section').offset().top - 20
          }, 300);
        }
      });
    }
  };

})(jQuery, Drupal);

