<?php

namespace Drupal\miniorange_saml\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

class ConfirmDeleteIdp extends ConfirmFormBase {

  protected $idpName;

  public function getFormId() {
    return "confirm_delete_idp_form";
  }

  public function buildForm(array $form, FormStateInterface $form_state) {

    $config = $this->config('miniorange_saml.settings');
    $this->idpName = $config->get('miniorange_saml_idp_name') ?: 'Identity Provider';

    $form['delete_text'] = [
      '#markup' => $this->t("Deleting this configuration means users won't be able to log in using %idpName anymore.", ['%idpName' => $this->idpName]),
    ];

    return parent::buildForm($form, $form_state);
  }

  public function getCancelUrl() {
    return new Url('miniorange_saml.sp_setup');
  }

  public function getQuestion() {
    return $this->t('Do you want to delete configurations of %IdPName?', ['%IdPName' => $this->idpName]);
  }

  public function getConfirmText() {
    return $this->t('Delete');
  }
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $editConfig = \Drupal::configFactory()->getEditable('miniorange_saml.settings');
    $editConfig
      ->clear('miniorange_saml_idp_name')
      ->clear('miniorange_saml_idp_issuer')
      ->clear('miniorange_saml_nameid_format')
      ->clear('miniorange_saml_idp_login_url')
      ->clear('miniorange_saml_idp_x509_certificate')
      ->clear('miniorange_saml_enable_login')
      ->clear('miniorange_saml_character_encoding')
      ->clear('miniorange_saml_custom_form_ids')
      ->clear('miniorange_saml_sso_link_on_custom_form')
      ->save();

    \Drupal::messenger()->addMessage($this->t('Identity Provider Configuration Successfully Deleted.'));

    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
