<?php

namespace Drupal\miniorange_saml\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\miniorange_saml\MoSupportIconForm;

/**
 * Provides a form for the miniorange_saml licensing new page.
 */
class MiniorangeLicensing extends FormBase
{

    /**
     * {@inheritdoc}
     */
    public function getFormId()
    {
        return "miniorange_saml_licensing_new";
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(array $form, FormStateInterface $form_state)
    {
        // Get module version.
        $module_data = \Drupal::service('extension.list.module')->getExtensionInfo('miniorange_saml');
        $version = $module_data['version'];
        
        // Get current plan (can be retrieved from config if available).
        $config = \Drupal::config('miniorange_saml.settings');
        $current_plan = $this->t('Community Version');
        
        // Define static labels for template.
        $labels = [
            'current_plan' => $this->t('Current Plan:'),
            'version' => $this->t('v'),
            'boost_your' => $this->t('Boost Your'),
            'saml' => $this->t('SAML'),
            'experience' => $this->t('Experience!'),
            'upgrade_description' => $this->t('Upgrade your plan to enjoy richer features, smarter automation, and faster support.'),
            'current_plan_badge' => $this->t('Current Plan'),
            'no_of_instances' => $this->t('Instance(s):'),
            'select_versions' => $this->t('Select Version:'),
            'upgrade_to' => $this->t('Upgrade to'),
            'features' => $this->t('Features'),
            'standard' => $this->t('Standard'),
            'premium' => $this->t('Premium'),
            'enterprise' => $this->t('Enterprise'),
        ];
        
        // Define features for the upgrade promotion.
        $features = [
            'left' => [
                $this->t('Authentication with Multiple IdPs'),
                $this->t('Advance Attribute & Role Mapping'),
                $this->t('SAML Single Logout'),
            ],
            'right' => [
                $this->t('Auto-sync IdP metadata'),
                $this->t('Force Authentication with IdP'),
                $this->t('Redirection to a custom page after login'),
            ],
        ];
        
        // Upgrade URL.
        $upgrade_url = Url::fromUri('https://plugins.miniorange.com/drupal-saml-single-sign-on-sso', ['external' => TRUE]);
        
        // Define plans data.
        $plans = [
            [
                'name' => 'STANDARD',
                'button_name' => 'Standard',
                'price' => '249',
                'price_period' => '/ Year',
                'instances' => '1',
                'versions' => 'Drupal 8+',
                'upgrade_url' => 'https://portal.miniorange.com/initializepayment?requestOrigin=drupal8_miniorange_saml_standard_plan',
                'plan_code' => 'drupal8_miniorange_saml_standard_plan',
                'is_current' => FALSE,
            ],
            [
                'name' => 'PREMIUM',
                'button_name' => 'Premium',
                'price' => '399',
                'price_period' => '/ Year',
                'instances' => '1',
                'versions' => 'Drupal 8+',
                'upgrade_url' => 'https://portal.miniorange.com/initializepayment?requestOrigin=drupal8_miniorange_saml_premium_plan',
                'plan_code' => 'drupal8_miniorange_saml_premium_plan',
                'is_current' => FALSE,
            ],
            [
                'name' => 'ENTERPRISE',
                'button_name' => 'Enterprise',
                'price' => '449',
                'price_period' => '/ Year',
                'instances' => '1',
                'versions' => 'Drupal 8+',
                'upgrade_url' => 'https://portal.miniorange.com/initializepayment?requestOrigin=drupal8_miniorange_saml_enterprise_plan',
                'plan_code' => 'drupal8_miniorange_saml_enterprise_plan',
                'is_current' => FALSE,
            ],
        ];

        // Define comparison features data for preview (3 features showing progressive improvement).
        $comparison_features_preview = [
            [
                'name' => $this->t('Redirection to a custom page after login'),
                'standard' => TRUE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Advanced attribute and role mapping'),
                'standard' => FALSE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Authentication with multiple IdP'),
                'standard' => FALSE,
                'premium' => FALSE,
                'enterprise' => TRUE,
            ],
        ];
        
        // Define full comparison features data.
        $comparison_features_full = [
            [
                'name' => $this->t('Unlimited authentication with one IdP'),
                'standard' => TRUE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Signed SAML Request'),
                'standard' => TRUE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Just-in-Time (JIT) Provisioning'),
                'standard' => TRUE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Redirection to a custom page after login'),
                'standard' => TRUE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Force authentication with IdP'),
                'standard' => TRUE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Basic attribute and role mapping'),
                'standard' => TRUE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('SAML Single Logout'),
                'standard' => FALSE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Redirect to a custom page after logout'),
                'standard' => FALSE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Advanced attribute and role mapping'),
                'standard' => FALSE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Invoke 2FA after SSO'),
                'standard' => FALSE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Integrated Windows Authentication (With ADFS)'),
                'standard' => FALSE,
                'premium' => TRUE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Authentication with multiple IdP'),
                'standard' => FALSE,
                'premium' => FALSE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Auto-sync IdP metadata'),
                'standard' => FALSE,
                'premium' => FALSE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Auto-redirect to IdP based on the domain of the user'),
                'standard' => FALSE,
                'premium' => FALSE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Restrict/allow SSO based on user attributes'),
                'standard' => FALSE,
                'premium' => FALSE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Support for the profile module mapping'),
                'standard' => FALSE,
                'premium' => FALSE,
                'enterprise' => TRUE,
            ],
            [
                'name' => $this->t('Generate custom X.509 certificates'),
                'standard' => FALSE,
                'premium' => FALSE,
                'enterprise' => TRUE,
            ],
        ];
        
        // Define Full Suite data.
        $suite_data = [
            'question' => $this->t('A Complete User Management Suite - Login Security via SSO + Automated User Creation and Deletion via SCIM.'),
            'price_prefix' => $this->t(''),
            'price_amount' => '$799',
            'price_period' => '/ Year',
            'price_instance' => '',
            'features' => [
                $this->t('All Enterprise features'),
                $this->t('Bidirectional SCIM based User Profile Sync'),
                $this->t('Support for Group Provisioning'),
                $this->t('Role Based Provisioning'),
            ],
            'button_text' => $this->t('Get quote'),
            'button_url' => 'mailto:drupalsupport@xecurify.com',
        ];
        
        // Get module path for images.
        global $base_url;
        $module_path = $base_url . '/' . \Drupal::service('extension.list.module')->getPath("miniorange_saml");
        
        // Define Related Products data with specific images for each product.
        $related_products = [
            [
                'title' => $this->t('Drupal User Provisioning & Sync (SCIM)'),
                'description' => $this->t('Automatically provision and sync users between your IdP and Drupal using SCIM protocol.'),
                'icon' => $module_path . '/includes/images/user_provisioning.png',
                'link_text' => $this->t('Learn more'),
                'link_url' => Url::fromUri('https://plugins.miniorange.com/drupal-user-provisioning-and-sync', ['external' => TRUE])->toString(),
            ],
            [
                'title' => $this->t('Two Factor Authentication'),
                'description' => $this->t('Add an extra layer of security with two-factor authentication for your Drupal site.'),
                'icon' => $module_path . '/includes/images/2fa.png',
                'link_text' => $this->t('Learn more'),
                'link_url' => Url::fromUri('https://plugins.miniorange.com/drupal-two-factor-authentication-2fa', ['external' => TRUE])->toString(),
            ],
            [
                'title' => $this->t('OTP Verification'),
                'description' => $this->t('Secure your login process with one-time password verification.'),
                'icon' => $module_path . '/includes/images/otp.png',
                'link_text' => $this->t('Learn more'),
                'link_url' => Url::fromUri('https://plugins.miniorange.com/drupal-otp-verification', ['external' => TRUE])->toString(),
            ],
            [
                'title' => $this->t('REST API Authentication'),
                'description' => $this->t('Authenticate and secure your REST API endpoints with advanced authentication methods.'),
                'icon' => $module_path . '/includes/images/rest_api.png',
                'link_text' => $this->t('Learn more'),
                'link_url' => Url::fromUri('https://plugins.miniorange.com/drupal-rest-api-authentication', ['external' => TRUE])->toString(),
            ],
            [
                'title' => $this->t('Session Management'),
                'description' => $this->t('Manage and control user sessions with advanced session management features.'),
                'icon' => $module_path . '/includes/images/session_management.png',
                'link_text' => $this->t('Learn more'),
                'link_url' => Url::fromUri('https://plugins.miniorange.com/drupal-session-management', ['external' => TRUE])->toString(),
            ],
            [
                'title' => $this->t('Website Security Pro'),
                'description' => $this->t('Protect your Drupal site with comprehensive security features and threat detection.'),
                'icon' => $module_path . '/includes/images/web_security.png',
                'link_text' => $this->t('Learn more'),
                'link_url' => Url::fromUri('https://plugins.miniorange.com/drupal-web-security-pro', ['external' => TRUE])->toString(),
            ],
        ];
        
        // Define Steps to Upgrade data.
        $upgrade_steps = [
            [
                'number' => '1',
                'title' => $this->t('Purchase Plan'),
                'instructions' => [
                    $this->t('In the <a href="#choose-your-plan"><strong>Choose Your Plan</strong></a> Section, select the plan you want to upgrade to - Standard, Premium, or Enterprise. Pick the number of instances and the Drupal version, then click the corresponding button.'),
                    $this->t('You will be redirected to the miniOrange login console. Proceed with the instructions.'),
                ],
            ],
            [
                'number' => '2',
                'title' => $this->t('Download Licensed Module'),
                'instructions' => [
                    $this->t('Download the licensed module(s) from the miniOrange portal in the <a href="https://portal.miniorange.com/downloads" target="_blank">Downloads</a> option form left side menu.'),
                ],
            ],
            [
                'number' => '3',
                'title' => $this->t('Export Configuration'),
                'instructions' => [
                    $this->t('Export the configuration of the community version from the <strong>Advance Settings</strong> tab in the module.'),
                ],
            ],
            [
                'number' => '4',
                'title' => $this->t('Remove Community Version'),
                'instructions' => [
                    $this->t('Uninstall and then delete the community version of the module from your Drupal site.'),
                ],
            ],
            [
                'number' => '5',
                'title' => $this->t('Install Licensed Version'),
                'instructions' => [
                    $this->t('Install the downloaded licensed module(s) on your Drupal site and import the configuration exported in step 3 into the licensed version.'),
                ],
            ],
        ];
        
        // Attach CSS library.
        $form['#attached']['library'][] = 'miniorange_saml/miniorange_saml.admin';
        
        // Render the Twig template.
        $form['licensing_content'] = [
            '#theme' => 'mo-saml-licensing-new',
            '#current_plan' => $current_plan,
            '#version' => $version,
            '#labels' => $labels,
            '#features' => $features,
            '#upgrade_url' => $upgrade_url,
            '#plans' => $plans,
            '#plan_heading' => $this->t('Choose Your Plan'),
            '#plan_description' => $this->t('Based on the SSO features that match your Drupal site\'s need.'),
            '#comparison_features_preview' => $comparison_features_preview,
            '#comparison_features_full' => $comparison_features_full,
            '#comparison_heading' => $this->t('Compare Plan Features'),
            '#comparison_description' => $this->t('Quickly compare all plans and understand which one fits your requirements best.'),
            '#comparison_link_text' => $this->t('View All Features'),
            '#comparison_link_url' => Url::fromUri('https://plugins.miniorange.com/drupal-saml-single-sign-on-sso', ['external' => TRUE])->toString(),
            '#suite_data' => $suite_data,
            '#related_products' => $related_products,
            '#related_products_heading' => $this->t('Related Products'),
            '#related_products_description' => $this->t('Find other miniOrange solutions that work well alongside your SAML SSO setup.'),
            '#related_products_link_text' => $this->t('View all products'),
            '#related_products_link_url' => Url::fromUri('https://plugins.miniorange.com/drupal', ['external' => TRUE])->toString(),
            '#upgrade_steps' => $upgrade_steps,
            '#upgrade_steps_heading' => $this->t('Steps to Upgrade'),
            '#upgrade_steps_intro' => $this->t('Follow the steps below to upgrade your plugin to the licensed version and unlock premium features.'),
        ];
        MoSupportIconForm::buildSupportIcon($form);
        
        return $form;
    }

    /**
     * {@inheritdoc}
     */
    public function submitForm(array &$form, FormStateInterface $form_state)
    {
        // No form submission needed for promotional page.
    }
}