<?php

namespace Drupal\miniorange_saml;

use Drupal\miniorange_saml\Api\MoAuthApi;

/**
 * @file
 * This class represents support information for customer.
 */
/**
 * The MiniorangeSamlSupport class.
 */
class MiniorangeSamlSupport {

  /**
   * Email.
   *
   * @var string|null
   */
  public $email;

  /**
   * Phone.
   *
   * @var string|null
   */
  public $phone;

  /**
   * Query.
   *
   * @var string|null
   */
  public $query;

  /**
   * QueryType.
   *
   * @var string|null
   */
  public $queryType;

  /**
   * Constructor.
   */
  public function __construct($email, $phone, $query, $queryType) {
    $this->email     = $email;
    $this->phone     = $phone;
    $this->query     = $query;
    $this->queryType = $queryType;

  }

  /**
   * Send support query.
   */
  public function sendSupportQuery() {
    $modules_info = \Drupal::service('extension.list.module')->getExtensionInfo('miniorange_saml');
    $modules_version = $modules_info['version'];

    $this->query = '[Drupal ' . Utilities::miniorangeGetDrupalCoreVersion() . ' SAML SP ' . $this->queryType . ' | ' . $modules_version . ' | ' . phpversion() . ' ] ' . $this->query;

    $fields = [
      'company' => $_SERVER['SERVER_NAME'],
      'email'   => $this->email,
      'ccEmail' => MiniorangeSamlConstant::SUPPORT_EMAIL,
      'query'   => $this->query,
    ];
    $url = MiniorangeSamlConstant::SUPPORT_QUERY;
    $api = new MoAuthApi();
    return $api->makeCurlCall($url, $fields);
  }

}
