<?php

namespace Drupal\miniorange_saml;

use Drupal\Component\Utility\Html;
use Drupal\Core\Url;

class MoSupportIconForm
{
    /**
     * This function helps in building support Icon that can be displayed on the forms.
     * On clicking on this a popup will appear with autofilled email, where user can write their query to seek support
     *
     * @param array $form form-field array
     *
     * @return void
     */
    public static function buildSupportIcon(array &$form): void
    {
        // Build absolute base URL
        $base_url = Url::fromUri('internal:/', ['absolute' => TRUE])->toString();

        // Get path to the module's assets
        $module_path = \Drupal::service('extension.list.module')->getPath('miniorange_saml');

        // Add the support icon to the form with modal dialog configuration
        $form['customer_support_icon'] = [
            '#markup' => sprintf(
                '<a class="use-ajax mo-support-button" data-dialog-type="modal" data-dialog-options="%s" href="%s">
                    <img src="%s" alt="%s">
                </a>',
                Html::escape(json_encode([
                    'width' => '600',
                    'height' => 'auto',
                    'modal' => true,
                ])),
                Html::escape(Url::fromRoute('miniorange_saml.support')->toString()),
                Html::escape($base_url . $module_path . '/includes/images/mo_customer_support.png'),
                Html::escape(t('Support Icon'))
            ),
        ];

        $form['#attached']['library'][] = 'core/drupal.ajax';
        $form['#attached']['library'][] = 'core/drupal.dialog.ajax';
        $form['#attached']['library'][] = 'miniorange_saml/miniorange_saml.admin';
    }
}