<?php

namespace Drupal\miniorange_saml_idp;

/**
 * Class containing constant values used in the Miniorange SAML IDP module.
 */
class MiniorangeSamlIdpConstants {
  const BASE_URL = 'https://login.xecurify.com';
  const LICENSE_PAGE_URL = '/admin/config/people/miniorange_saml_idp/Licensing';
  const SUPPORT_EMAIL = 'drupalsupport@xecurify.com';
  const CREATE_ACCOUNT_URL = 'https://portal.miniorange.com/signup';
  const FROM_MAIL = 'no-reply@xecurify.com';
  const FROM_NAME = 'miniOrange';
  const API_INVALID_CRED_RESPONSE = 'Invalid username or password. Please try again.';
  const API_QUERY_SUCCESS_RESPONSE = 'Query submitted.';
  const API_INVALID_EMAIL_RESPONSE = 'Invalid email.';
  const API_NO_RESPONSE = 'Something went wrong.';
  const NOT_INCLUDE_IN_MAPPING = ['pass' => 'pass', 'uuid' => 'uuid', 'init' => 'init'];
  const MODULE_INFO = [
    'name' => 'SAML Identity Provider',
    'saml_features' => 'https://plugins.miniorange.com/drupal-saml-idp',
    'setup_guides' => 'https://www.drupal.org/docs/contributed-modules/saml-idp-20-single-sign-on-sso-saml-identity-provider',
    'case_studies' => 'https://www.drupal.org/node/3196471/case-studies',
    'landing_page' => 'https://plugins.miniorange.com/drupal',
    'customers' => 'https://plugins.miniorange.com/drupal-customers',
    'drupalsupport' => self::SUPPORT_EMAIL,
  ];
  const MINIORANGE_PRIVATE_KEY = '-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDxJPzwE8E1AFVU
+rmMFwUjRI81BUp7Q/rjP1xUQsPv3qvv1YanTt1r01pI7fD4MboOSMQa9jBqEoJL
0bPFAxOrunnIdTZrLaFogxaGih0DOhueUBsbbeHWRM7FvF4TGlTzGpIh77fDMiop
DKeUi/jGYSH4zLxwu98M6+4yaR9WQtFI5GZ6pMAj/B407eEptDewpAv19GAETwyK
l4oNwoGg+30j6sCuGyi/9XZrVCjZ3LXxzLjKbzWf7wQi+CZtrqtlySEt/pSuSHlx
mcq1inIvN3cPHiGjrDhhSWPstgJqK3XqsDFwCDQLIl7hMuWTTBV8npZgIohARcl9
lCLlB2v5AgMBAAECggEBAJMPKo3Cjl4jQObdLJCpbUGvyuHbwytfLr6tYkIkoVdE
ZXiSsFaR+uiJ8RJuwTirIrsZVzbWEnptpTZVwZsRIErnIuPDz5cXMcsJvo/35G+W
XUdztMRKg6JnPe5KzNg7g7jp6Fp31YpdqmZ0SDKIFgPtMomHWhgqCoHX0+C8SRcR
44AM9f1As0wW0fpe8QcWuL1WvTwELfuigpubZgeR/R7tjQlK5G2gnUMRRNZssnud
BxFM+YpuQDWRhvqavX17YadWEYHhIrfc+LXpBEQqylT7iMOsRtUJb4EaPHtPVWSH
3lf7905KyGtbgJmtx6TaVD25kKJWqlvJNZku1QPq5h0CgYEA+iGofHKZZPYJgtHt
kGYCJjuJTRMdWEkE9uU6IIOBb41ReVdf/laH/y59DgYhkwZlNmqJpXHBDmw6DhGt
B36lm6QUBSqF7dpRKBu9mkGJhXq46pA+7YYcZPja/poZqpHwKgFyQL85r94Vmya5
GtVfZbD/xBWyl1HJcj8Tjr/RFVsCgYEA9s1aJZllIrFQGr+IUPtlxQDqfAxroFuf
kWOOlODfaumIQlxDpkOvqQKDiM01p2tbwkg6Mui3nbUR1zmq8Xr8OxwEcJvFo601
rqrkWtk52F6mzR3/g9cM/O4Q+9mLrbIPlM3exMSZNPyOUxPYo6wI5sCcZ4Pql2oz
PB2BgZWegDsCgYEAxtAX9oq0KA5zstqfZAXgsXjjAjMuQO0RGBlNIWjFaeA+oR70
+tjWkdrmpU30Q8NykVUPAUSweYFGh8Y+7NUaVuKM0ypgd5Tuqt2Zz9FFuKW58x8i
FXNigFNY5cOgoPYMmaa6pIIaHRJ9w+t8d7qfb9nHAZlpcWMdpkRCjFUkoD8CgYA0
V2rV7IlZaTdu5M35NsfnlwEj29J7iNL3l6CmjGZ1mx+Ny1mBintXobPZsIO/hPJJ
6t2E7Hv8k2k8Nvu9CPMzaga7Bx5MTzDCYXXampU9AR3pBIKrKFGV1rt9Xi7UYJ4T
VfH30yYW6bUZg2z/kT22CoVhIsX+5MQG7M8Jd3zM/wKBgFV2r23OXcZaNpZwOPEn
OAgzQvdofg6KNRo/gaQQuTkPy66+qf6boyZw2CRk7PeuvZdfhvzwO+tlB479KbkE
BoU9PqQQJhK44E/CzohErA8Prol2gW/r6DaY4SXGj6CYwKprHd+jOngtK/liERmZ
aYPmHE7sLjzNoEjp5aj2cB78
-----END PRIVATE KEY-----';

  const MINIORANGE_PUBLIC_CERTIFICATE = '-----BEGIN CERTIFICATE-----
MIID/zCCAuegAwIBAgIJAMePaIrAItqFMA0GCSqGSIb3DQEBCwUAMIGVMQswCQYD
VQQGEwJJTjEUMBIGA1UECAwLTUFIQVJBU0hUUkExDTALBgNVBAcMBFBVTkUxEzAR
BgNVBAoMCk1JTklPUkFOR0UxEzARBgNVBAsMCk1JTklPUkFOR0UxEzARBgNVBAMM
Ck1JTklPUkFOR0UxIjAgBgkqhkiG9w0BCQEWE2luZm9AbWluaW9yYW5nZS5jb20w
HhcNMTYwMjA4MTYzNzMzWhcNMjYwMjA1MTYzNzMzWjCBlTELMAkGA1UEBhMCSU4x
FDASBgNVBAgMC01BSEFSQVNIVFJBMQ0wCwYDVQQHDARQVU5FMRMwEQYDVQQKDApN
SU5JT1JBTkdFMRMwEQYDVQQLDApNSU5JT1JBTkdFMRMwEQYDVQQDDApNSU5JT1JB
TkdFMSIwIAYJKoZIhvcNAQkBFhNpbmZvQG1pbmlvcmFuZ2UuY29tMIIBIjANBgkq
hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8ST88BPBNQBVVPq5jBcFI0SPNQVKe0P6
4z9cVELD796r79WGp07da9NaSO3w+DG6DkjEGvYwahKCS9GzxQMTq7p5yHU2ay2h
aIMWhoodAzobnlAbG23h1kTOxbxeExpU8xqSIe+3wzIqKQynlIv4xmEh+My8cLvf
DOvuMmkfVkLRSORmeqTAI/weNO3hKbQ3sKQL9fRgBE8MipeKDcKBoPt9I+rArhso
v/V2a1Qo2dy18cy4ym81n+8EIvgmba6rZckhLf6Urkh5cZnKtYpyLzd3Dx4ho6w4
YUlj7LYCait16rAxcAg0CyJe4TLlk0wVfJ6WYCKIQEXJfZQi5Qdr+QIDAQABo1Aw
TjAdBgNVHQ4EFgQU3Mp268a2wkuy4lkHJwYz1p+BMD8wHwYDVR0jBBgwFoAU3Mp2
68a2wkuy4lkHJwYz1p+BMD8wDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQsFAAOC
AQEAcRg44YpnKS0yjd+IByIxqModT6N86QzfcmcHEXCkAN8HWb6pEj0/BBWMb/Bt
SpZNCzrk99y30rAzZxF2yNdvG+0NO1g48/bnE9Usg4DoYZTQ1jsh/2shALPRu6RH
HFmGtoqRtQzPgUoOuzBJg2/+rTFM65snTQc3uaOZu440bhwMbI/mrD6Si2jw0/7d
uET+zPo5BJl1YRrX4EuzP4/ZV2MiD1Pwy0/QZ27mqSsaFILGG/bG4YwsQ73ODKVn
GTV+AezX2owcZF5QqDRGX5fG0d094JdSFCCvoWdCIBYSvnnCXQiq5nV8l2p3SRAl
EfCUl6tQwLsTOgUKXgcp1+L/AQ==
-----END CERTIFICATE-----';

}

