<?php declare(strict_types=1);

namespace Drupal\minisite\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * File extension constraint.
 */
#[Constraint(
  id: 'MinisiteArchive',
  label: new TranslatableMarkup('Minisite Archive', [], ['context' => 'Validation']),
  type: 'minisite'
)]
class MinisiteArchiveConstraint extends SymfonyConstraint {

  public string $invalidArchiveConstraint = "File %file is not an archive file.";

  public string $archiveExtensionConstraint = "The archive must have a valid file extension";

  public string $archiveStructureConstraint = "The archive root must consist of one and only one directory, except for any whitelisted ones.";

  public string $archiveIndexFileConstraint = "The archive's top level directory must contain the configured index file"; // TODO use the exact filename

  public string $fileExtensionConstraint     = "No file in the archive can have a disallowed file extension"; // TODO use offending file extension

  public string $filePathLengthConstraint   = "File path lengths cannot exceed the maximum value"; // TODO mention exact value

  public string $missingFile = "Unable to find the submitted file";

  /**
   * The allowed file extensions.
   *
   * @var string
   */
  public string $extensions;

}
