<?php

declare(strict_types=1);

namespace Drupal\mjml_preview\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Module settings form.
 */
class MjmlSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'mjml_preview_settings';
  }

  /**
   * {@inheritdoc}
   *
   * @return string[]
   *   An array of configuration object names that are editable if called in
   *   conjunction with the trait's config() method.
   */
  protected function getEditableConfigNames(): array {
    return ['mjml_preview.settings'];
  }

  /**
   * {@inheritdoc}
   *
   * @param mixed[] $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return mixed[]
   *   The form structure.
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form = parent::buildForm($form, $form_state);
    $config = $this->config('mjml_preview.settings');

    $form['app_id'] = [
      '#type' => 'textfield',
      '#required' => TRUE,
      '#title' => $this->t('Application ID'),
      '#default_value' => $config->get('app_id'),
    ];
    $form['secret_key'] = [
      '#type' => 'key_select',
      '#key_filters' => ['type' => 'authentication'],
      '#required' => TRUE,
      '#title' => $this->t('Secret key'),
      '#default_value' => $config->get('secret_key'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   *
   * @param mixed[] $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    parent::submitForm($form, $form_state);

    $config = $this->config('mjml_preview.settings');
    $config->set('app_id', $form_state->getValue('app_id'));
    $config->set('secret_key', $form_state->getValue('secret_key'));
    $config->save();
  }

}
