/**
 * @file
 * Share button with graceful fallback.
 */

((Drupal, once) => {
  Drupal.behaviors.mobileNativeShare = {
    attach: (context) => {
      once('mobileNativeShare', '.mn-share-button', context).forEach(
        (button) => {
          button.addEventListener('click', (e) => {
            e.preventDefault();

            const url = button.getAttribute('data-url');
            const title = button.getAttribute('data-title');
            const description = button.getAttribute('data-description');

            if (navigator.share) {
              // Browsers that support the Web Share API
              navigator
                .share({
                  title,
                  text: description,
                  url,
                })
                .catch(console.error);
            } else if (navigator.clipboard) {
              // Fallback via Clipboard API
              navigator.clipboard
                .writeText(url)
                .then(() => {
                  alert(Drupal.t('Link copied to clipboard!'));
                })
                .catch(() => {
                  prompt(Drupal.t('Copy this link:'), url);
                });
            } else {
              // Old browsers
              prompt(Drupal.t('Copy this link:'), url);
            }
          });
        },
      );
    },
  };
})(Drupal, once);
