(function ($, Drupal, once) {
  Drupal.behaviors.mobileNumberLogin = {
    attach: function (context, settings) {
      once('mobileNumberLogin', 'input.mobile-number-login', context).forEach(function (element) {
        window.intlTelInput(document.querySelector(".mobile-number-login"), {
          preferredCountries: ["us", "co", "in", "de"],
          separateDialCode: true,
          utilsScript:
            "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
        });
        $('.user-login-form .form-submit').click(function(e) {
          e.preventDefault();
          if ($('.mobile-number-login').val() != '') {
            $('.mobile-number-login').val($('.iti__selected-dial-code').text() + '-' + $('.mobile-number-login').val());
          }
          $('.user-login-form').submit();
        });
        $('.mobile-number-login').keyup(function() {
          this.value = this.value.replace(/[^0-9]/g, '');
        }).blur(function() {
          $('[name="name"]').val(this.value);
        });
        $('input[name="mobileradio"]').change(function() {
          $('.mobile-number-login, [name="name"]').val('');
          if ($('input[name="mobileradio"]:checked').val() == 'mobile') {
            $('.name-wrapper').addClass('hidden');
            $('.mobile-wrapper').removeClass('hidden');
          }
          else {
            $('.name-wrapper').removeClass('hidden');
            $('.mobile-wrapper').addClass('hidden');
          }
        });
      });
    }
  };
})(jQuery, Drupal, once);