# Model Viewer Formatter

A Drupal module that provides a field formatter for displaying 3D model files (OBJ, GLTF, GLB) using Google's Model Viewer web component.

## Features

- Display 3D OBJ, GLTF, and GLB files in an interactive viewer
- Configurable width and height
- Auto-rotation option
- Camera controls for zooming and panning
- Customizable background color
- Optional poster image
- AR mode support (on compatible devices)
- Responsive design with loading indicator

## Installation

1. Place this module in your `/modules/custom` directory
2. Enable the module via Drush: `drush en model_viewer_formatter -y`
   Or via the Drupal UI: Admin → Extend → Check "Model Viewer Formatter" → Install

## Usage

### Setting up a file field

1. Go to Structure → Content types → [Your content type] → Manage fields
2. Add or edit a File field
3. Go to "Manage display" for your content type
4. Change the format for your file field to "Model Viewer (Google)"
5. Click the settings icon to configure:
   - **Width**: Set viewer width (e.g., `100%`, `800px`)
   - **Height**: Set viewer height (e.g., `600px`, `50vh`)
   - **Auto-rotate**: Enable/disable automatic rotation
   - **Camera controls**: Enable/disable zoom and pan controls
   - **Background color**: Set background color in hex format
   - **Poster image**: Optional URL to a preview image

### Uploading 3D models

1. Upload OBJ, GLTF, or GLB files to your file field
2. The module will automatically detect the file type and render it with Model Viewer

## File Format Support

- **OBJ**: Wavefront OBJ format
- **GLTF**: GL Transmission Format (JSON)
- **GLB**: Binary GL Transmission Format

## Requirements

- Drupal 10 or 11
- Internet connection (loads Google's Model Viewer from CDN)

## Technical Details

The module uses Google's Model Viewer web component (v4.0.0) loaded from Google's CDN. The viewer provides:
- WebGL-based rendering
- AR mode for mobile devices
- Automatic camera positioning
- Progressive loading

## License

GPL-2.0+

## Maintainer

Custom module for Drupal project

