<?php

namespace Drupal\moderated_content_bulk_publish\Plugin\Action;

use Drupal\node\NodeInterface;

/**
 * An example action covering most of the possible options.
 *
 * If type is left empty, action will be selectable for all
 * entity types.
 *
 * @Action(
 *   id = "draft_current_revision_action",
 *   label = @Translation("Draft Current Revision"),
 *   type = "node",
 *   confirm = TRUE,
 *   requirements = {
 *     "_permission" = "moderated content bulk draft",
 *   },
 * )
 */
class DraftCurrentRevisionAction extends RevisionActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    /*
     * All config resides in $this->configuration.
     * Passed view rows will be available in $this->context.
     * Data about the view used to select results and optionally
     * the batch context are available in $this->context or externally
     * through the public getContext() method.
     * The entire ViewExecutable object  with selected result
     * rows is available in $this->view or externally through
     * the public getView() method.
     */
    $this->getLogger('moderated_content_bulk_publish')->notice("Executing draft latest revision of " . $entity->label());

    $this->adminModeratedContent->setValues($entity, NodeInterface::NOT_PUBLISHED);
    $current_translation_only = $this->configuration['current_translation_only'];
    $entity = $this->adminModeratedContent->draft($current_translation_only);

    //check if published
    if ($entity->isPublished()){
      $msg = "Something went wrong, the entity must be drafted by this point.  Review your content moderation configuration make sure you have archive state which sets current revision and a draft state and try again.";
      $this->messenger()->addError(mb_convert_encoding($msg, 'UTF-8'));
      $this->getLogger('moderated_content_bulk_publish')->warning($msg);
      return $msg;
    }
    $msg = 'The node %s has been set to draft moderation state (all translations).';
    if ($current_translation_only) {
      $msg = 'The node %s has been set to draft moderation state (only selected translations).';
    }
    return sprintf($msg, $entity->id());
  }

}
