<?php

namespace Drupal\moderated_content_bulk_publish\Plugin\Action;

/**
 * An example action covering most of the possible options.
 *
 * If type is left empty, action will be selectable for all
 * entity types.
 *
 * @Action(
 *   id = "pin_content_action",
 *   label = @Translation("Pin current revision (sticky)"),
 *   type = "node",
 *   confirm = TRUE,
 *   requirements = {
 *     "_permission" = "moderated content bulk pin",
 *   },
 * )
 */
class PinContentAction extends RevisionActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    /*
     * All config resides in $this->configuration.
     * Passed view rows will be available in $this->context.
     * Data about the view used to select results and optionally
     * the batch context are available in $this->context or externally
     * through the public getContext() method.
     * The entire ViewExecutable object  with selected result
     * rows is available in $this->view or externally through
     * the public getView() method.
     */
    $this->getLogger('moderated_content_bulk_publish')->notice("Executing Pin content of " . $entity->label());

    $this->adminPin->setValues($entity, $entity->isSticky());
    $current_translation_only = $this->configuration['current_translation_only'];
    $entity = $this->adminPin->pin($current_translation_only);

    // Check if pinned.
    if (!$entity->isSticky()){
      $msg = "Something went wrong, the entity must be pinned by this point.";
      $this->messenger()->addError(mb_convert_encoding($msg, 'UTF-8'));
      $this->getLogger('moderated_content_bulk_publish')->warning($msg);
      return $msg;
    }

    $msg = 'The node %s has been set to sticky (all translations).';
    if ($current_translation_only) {
      $msg = 'The node %s has been set to sticky (only selected translations).';
    }
    return sprintf($msg, $entity->id());
  }

}
