<?php

namespace Drupal\moderated_content_bulk_publish\Plugin\Action;

use Drupal\node\NodeInterface;
use Drupal\Core\Render\Markup;

/**
 * An example action covering most of the possible options.
 *
 * If type is left empty, action will be selectable for all
 * entity types.
 *
 * @Action(
 *   id = "publish_latest_revision_action",
 *   label = @Translation("Publish Latest Revision"),
 *   type = "node",
 *   confirm = TRUE,
 *   requirements = {
 *     "_permission" = "moderated content bulk publish",
 *   },
 * )
 */
class PublishLatestRevisionAction extends RevisionActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    /*
     * All config resides in $this->configuration.
     * Passed view rows will be available in $this->context.
     * Data about the view used to select results and optionally
     * the batch context are available in $this->context or externally
     * through the public getContext() method.
     * The entire ViewExecutable object  with selected result
     * rows is available in $this->view or externally through
     * the public getView() method.
     */
    $this->getLogger('moderated_content_bulk_publish')->notice("Executing publish latest revision of " . $entity->label());

    $this->adminModeratedContent->setValues($entity, NodeInterface::PUBLISHED);
    $current_translation_only = $this->configuration['current_translation_only'];
    $entity = $this->adminModeratedContent->publish($errorMessage, $msgIsToken, $msgIsPublished, $msgIsAbsoluteURL, $current_translation_only);
    if (!isset($entity) && !empty($errorMessage)) {
      // When publish () return NULL, we output messages and to stop the process.
      $msgError = Markup::create(mb_convert_encoding($errorMessage, 'UTF-8'));
      $this->messenger()->addWarning($msgError);
      if (!empty($msgIsToken)) {
        $msgToken = Markup::create($msgIsToken);
        $this->messenger()->addWarning($msgToken,TRUE);
      }
      if (!empty($msgIsPublished)) {
        $msgPublished = Markup::create($msgIsPublished);
        $this->messenger()->addWarning($msgPublished,TRUE);
      }
      if (!empty($msgIsAbsoluteURL)) {
        $msgAbsoluteURL = Markup::create($msgIsAbsoluteURL);
        $this->messenger()->addWarning($msgAbsoluteURL,TRUE);
      }
      return $msgError;
    }

    // Check if published
    if (!$entity->isPublished()) {
      $msg = "Something went wrong, the entity must be published by this point.  Review your content moderation configuration make sure you have archive state which sets current revision and a published state and try again.";
      $this->messenger()->addError(mb_convert_encoding($msg, 'UTF-8'));
      $this->getLogger('moderated_content_bulk_publish')->warning($msg);
      return $msg;
    }
    $msg = 'The node %s has been set to published moderation state (all translations).';
    if ($current_translation_only) {
      $msg = 'The node %s has been set to published moderation state (only selected translations).';
    }
    return sprintf($msg, $entity->id());
  }

}
