<?php

namespace Drupal\moderated_content_bulk_publish\Plugin\Action;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Session\AccountInterface;
use Drupal\node\NodeInterface;

/**
 * Provides an action that can save any entity.
 *
 * @Action(
 *   id = "node_save_moderated_action",
 *   action_label = @Translation("Save moderated content"),
 *   deriver = "Drupal\Core\Action\Plugin\Action\Derivative\EntityChangedActionDeriver",
 *   requirements = {
 *     "_permission" = "moderated content bulk save content",
 *   },
 * )
 */
class SaveModeratedNodeAction extends RevisionActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    $this->getLogger('moderated_content_bulk_publish')->notice("Executing Change Owner content of " . $entity->label());

    $this->adminModeratedContent->setValues($entity, NodeInterface::NOT_PUBLISHED);
    $current_translation_only = $this->configuration['current_translation_only'];
    /** @var \Drupal\node\NodeInterface $entity */
    $entity = $this->adminModeratedContent->saveContent($current_translation_only);

    $msg = 'The node %s has been saved (all translations).';
    if ($current_translation_only) {
      $msg = 'The node %s has been saved (only selected translations).';
    }
    return sprintf($msg, $entity->id());
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    // It's not necessary to check the changed field access here, because
    // Drupal\Core\Field\ChangedFieldItemList would anyway return 'not allowed'.
    // Also changing the changed field value is only a workaround to trigger an
    // entity resave. Without a field change, this would not be possible.
    /** @var \Drupal\Core\Entity\EntityInterface $object */
    $access = $object->access('update', $account, TRUE);
    $access = $this->checkRequiredPermissionAccess($access);
    return $return_as_object ? $access : $access->isAllowed();
  }

}
