(function (Drupal, drupalSettings) {
  'use strict';

  if (!drupalSettings || !drupalSettings.modovisa) return;
  var cfg = drupalSettings.modovisa;
  if (!cfg.token) return;

  // Prevent duplicate injection.
  if (document.getElementById('modovisa-loader')) return;

  var s = document.createElement('script');
  s.id = 'modovisa-loader';
  s.src = cfg.scriptUrl || 'https://cdn.modovisa.com/modovisa.min.js';
  s.async = true;
  if (cfg.defer) s.defer = true;
  s.dataset.token = cfg.token;

  // Optional: pass the canonical host as a hint (not required).
  try {
    s.dataset.domain = window.location.hostname.replace(/^www\./, '');
  } catch (e) {}

  document.head.appendChild(s);
})(Drupal, drupalSettings);