# Modovisa (Drupal)

Adds the Modovisa real-time tracking script to your Drupal 10/11 site.  
Loads the tracker in `<head>` on non-admin pages.

## Requirements
- Drupal core ^10 || ^11
- PHP 8.1+
- A valid Modovisa tracking token
- Your Modovisa site domain must match the Drupal site domain (including subdomain)

## Install
1. Place this folder at `web/modules/custom/modovisa` (or `modules/custom/modovisa`).
2. Enable **Modovisa** at **Extend**.
3. Go to **Configuration → System → Modovisa**, enable it, paste your project token, and save.
4. Clear caches (**Configuration → Development → Performance** or `drush cr`).
5. Visit your front page and verify the script appears in page source `<head>`.

## Notes
- The module automatically **skips admin routes** (e.g., `/admin/*`).
- Tracking is injected via a small loader library and added to `drupalSettings` for flexibility.
- If you use BigPipe, the loader is guarded to run once per page.

## Troubleshooting
- **Script not loading**: Confirm the module is enabled, “Enable tracking” is checked, and the token is correct.
- **No data in Modovisa**: Ensure the domain in your Modovisa project matches the Drupal site domain (e.g., `drupal.example.com` vs `example.com`).
- **Caching/CDN**: After enabling or changing settings, clear Drupal caches (and any reverse proxy/CDN caches).

## Uninstall
1. Disable the module at **Extend**.
2. Uninstall to remove configuration: **Extend → Uninstall** (or `drush pm:uninstall modovisa`).

## License
GPL-2.0-or-later. See `LICENSE.txt`.