<?php

namespace Drupal\modovisa\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class ModovisaSettingsForm extends ConfigFormBase {

  public function getFormId() {
    return 'modovisa_settings_form';
  }

  protected function getEditableConfigNames() {
    return ['modovisa.settings'];
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('modovisa.settings');

    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Modovisa tracking'),
      '#default_value' => (bool) $config->get('enabled'),
    ];

    $form['token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Tracking token'),
      '#required' => TRUE,
      '#default_value' => $config->get('token') ?: '',
      '#description' => $this->t('Paste your Modovisa tracking token.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->configFactory->getEditable('modovisa.settings')
      ->set('enabled', (bool) $form_state->getValue('enabled'))
      ->set('token', trim($form_state->getValue('token') ?: ''))
      ->save();

    parent::submitForm($form, $form_state);
  }
}
