<?php

/**
 * @file
 * Contains post-update hooks.
 */

use Drupal\Core\Config\Entity\ConfigEntityUpdater;

/**
 * Converts the location property to an array.
 */
function module_builder_post_update_location_array(&$sandbox) {
  $count = 0;

  \Drupal::classResolver(ConfigEntityUpdater::class)->update($sandbox, 'module_builder_module', function ($module) use (&$count) {
    if (empty($module->location)) {
      $module->location = [
        'location_type' => 'standard',
      ];

      $count++;
      return TRUE;
    }
    elseif (is_string($module->location)) {
      $custom_location = $module->location;
      $module->location = [
        'location_type' => 'custom',
        'custom' => $custom_location,
      ];

      $count++;
      return TRUE;
    }
    else {
      return FALSE;
    }
  });

  $result = t('@count module entities updated.', [
    '@count' => $count,
  ]);
  return $result;
}
