(function ($, Drupal) {
  "use strict";

  // Configure Ace base path before loading
  if (typeof ace !== 'undefined') {
    // If ace is already loaded, configure it
    var basePath = drupalSettings.moduleFileEditor.aceBaseUrl;
    ace.config.set('basePath', basePath);
    ace.config.set('modePath', basePath);
    ace.config.set('themePath', basePath);
    ace.config.set('workerPath', basePath);
  } else {
    // Create a script element to load ace with proper configuration
    var script = document.createElement('script');
    script.src = drupalSettings.moduleFileEditor.aceEditorUrl;
    script.onload = function() {
      // Configure ace after it loads
      var basePath = drupalSettings.moduleFileEditor.aceBaseUrl;
      ace.config.set('basePath', basePath);
      ace.config.set('modePath', basePath);
      ace.config.set('themePath', basePath);
      ace.config.set('workerPath', basePath);
    };
    document.head.appendChild(script);
  }

})(jQuery, Drupal);