# Module Manager

**Module Manager** is a Drupal module that makes it easy to search, install, update, and remove community modules from Drupal.org directly through your site's administrative interface.

## Features

- Search and filter available modules from Drupal.org.
- View details, releases, and links for download/source code.
- Automated module installation (with dependency validation).
- Remove and uninstall modules via the interface.
- List modules installed via Module Manager.

## Installation

1. **Enable the module via Drupal Admin or Drush:**
   ```
   drush en module_manager -y
   ``` module_manager /path/to/docroot/modules/custom/

2. **Create the required folder for module extraction:**
   ```
   mkdir -p /path/to/docroot/modules/module_manager_contrib
   ```

3. **Set the folder permissions to the Apache user (example for www-data):**
   ```
   chown www-data:www-data /path/to/docroot/modules/module_manager_contrib
   chmod 775 /path/to/docroot/modules/module_manager_contrib
   ```

   > **Note:** Apache must have write permission to this folder so Module Manager can extract and move downloaded modules.

## Usage

- Go to the administration menu and look for "Module Manager" to search, install, or remove community modules.
- Use the search and category filters to find compatible modules.
- To install a module, click "View" and then "Install" on the desired version.
- To remove, use the "Remove module" option on the module details screen.

## Requirements

- Drupal 9 or higher.
- Write permissions for the Apache user on the `docroot/modules/module_manager_contrib` folder.

## Security

- Only modules with security coverage, stable releases, and compatible with your Drupal version are listed.
- The module validates dependencies before installation.

## Support

For questions, suggestions, or issues, use the [project's issue queue on Drupal.org](https://www.drupal.org/project/issues/module_manager).
