/**
 * @file
 * Module filter functionality for the modules overview page.
 */
(function (Drupal, once) {
  'use strict';

  /**
   * Filter the modules list based on user input.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the behavior for the module filter.
   */
  Drupal.behaviors.modulesListModuleFilter = {
    attach: function (context) {
      once('module-filter', 'input.module-filter-text', context).forEach(function (input) {
        const table = document.querySelector(input.getAttribute('data-table'));
        const rows = table ? table.querySelectorAll('tbody tr') : [];

        function filterModuleList(e) {
          const query = e.target.value.toLowerCase();

          // Filter if the length of the query is at least 2 characters.
          if (query.length >= 2) {
            // Hide rows that don't match the search term.
            rows.forEach(function (row) {
              const name = row.querySelector('td:nth-child(1)').textContent.toLowerCase();
              const description = row.querySelector('td:nth-child(3)').textContent.toLowerCase();
              const machine_name = row.querySelector('td:nth-child(4)').textContent.toLowerCase();

              if (name.includes(query) || description.includes(query) || machine_name.includes(query)) {
                row.style.display = '';
              }
              else {
                row.style.display = 'none';
              }
            });
          }
          else {
            // If the search query is less than 2 characters, show all rows.
            rows.forEach(function (row) {
              row.style.display = '';
            });
          }
        }

        // Attach the filter event.
        input.addEventListener('keyup', filterModuleList);
      });
    }
  };
})(Drupal, once);