# Modules Manager Enhanced

A powerful Drupal module that enhances the modules administration page (`/admin/modules`) with advanced filtering capabilities and performance optimizations.

## Features

🚀 **Server-side Performance Optimization**

- Pre-filters modules before form rendering
- Reduces memory usage and page load time
- Only loads selected package data into memory

📦 **Package-based Filtering**

- Filter modules by package (Core, Administration, Field types, etc.)
- Multi-select filtering with clean URLs
- Smart default packages for optimized initial load

🎯 **User Experience**

- Professional interface with intuitive controls
- Clean URLs: `admin/modules?packages=Core&Administration`
- Reset to default packages functionality
- Backward compatibility with standard module names filter


## Installation


1. **Download and Enable the module:**

   ```bash
   drush en modules_manager_enhanced -y
   ```
3. **Clear cache:**

   ```bash
   drush cr
   ```

**Note:** Module uses existing "Administer modules" permission - no additional permissions needed.

## Usage

### Basic Usage

1. Navigate to `/admin/modules`
2. Use the "Filter by Package" section at the top
3. Select one or multiple packages from the dropdown
4. Click "Apply Filter" to see only selected packages
5. Click "Reset Filter" to return to default packages

### URL Parameters

The module supports clean URL filtering:

```
# Filter by single package
/admin/modules?packages=Core

# Filter by multiple packages
/admin/modules?packages=Core&Administration&Migration
```

### Default Behavior

By default, the module loads only **Core** and **Administration** packages to optimize performance.

## Technical Details

### Architecture Components

1. **FormAlterService** (`src/Service/FormAlterService.php`)

   - Alters the system modules form
   - Adds filtering interface
   - Applies server-side filtering
2. **ModulesFilterSubscriber** (`src/EventSubscriber/ModulesFilterSubscriber.php`)

   - Intercepts requests to `/admin/modules`
   - Pre-filters module data for performance
   - Caches filtered results
3. **JavaScript** (`js/modules-manager-enhanced.js`)

   - Handles filter interactions
   - Builds clean URLs
   - Manages reset functionality
4. **CSS** (`css/modules-manager-enhanced.css`)

   - Styles filter interface
   - Fixes accordion arrow positioning
   - Responsive design

### Performance Optimizations

- **Pre-rendering filtering**: Modules are filtered before form construction
- **Memory efficiency**: Only selected package data is loaded
- **Static caching**: Module information cached during request
- **Reduced DOM complexity**: Unwanted sections never created

### Browser Compatibility

- Modern browsers (Chrome, Firefox, Safari, Edge)
- Responsive design for mobile/tablet
- Graceful degradation for older browsers

## Development

### Requirements

- Drupal 9/10/11
- PHP 7.4+
- Modern browser with JavaScript enabled

## Changelog

### Version 1.0.0

- Initial release
- Server-side filtering implementation
- Package-based filtering
- Performance optimizations
- Clean URL support
