(function ($, Drupal) {
  'use strict';

  /**
   * Modules Manager Enhanced behavior.
   */
  Drupal.behaviors.modulesManagerEnhanced = {
    attach: function (context, settings) {
      // Only run once per page
      if (context !== document) {
        return;
      }

      // Find the filter elements
      var $packagesFilter = $('#packages-filter');
      var $applyButton = $('.apply-filter');
      var $resetButton = $('.reset-filter');

      if ($packagesFilter.length === 0 || $applyButton.length === 0) {
        return;
      }

      // Apply filter button handler
      $applyButton.on('click', function(e) {
        e.preventDefault();

        var selectedPackages = $packagesFilter.val() || [];

        if (selectedPackages.length === 0) {
          alert('Please select at least one package to filter.');
          return;
        }

        // Build URL with filter parameters - clean format
        var moduleSettings = settings.modulesManagerEnhanced || {};
        var url = moduleSettings.modulesPageUrl || '/admin/modules';
        
        if (selectedPackages.length > 0) {
          var cleanPackages = selectedPackages.filter(function(pkg) {
            return pkg && pkg.trim();
          });
          
          if (cleanPackages.length > 0) {
            url += '?packages=' + encodeURIComponent(cleanPackages.join('&'));
          }
        }

        window.location.href = url;
      });

      // Reset filter button handler
      $resetButton.on('click', function(e) {
        e.preventDefault();
        
        // Clear selections and redirect to default filtered page
        var moduleSettings = settings.modulesManagerEnhanced || {};
        var url = moduleSettings.modulesPageUrl || '/admin/modules';
        
        // Apply default packages for optimization
        if (moduleSettings.defaultPackages && moduleSettings.defaultPackages.length > 0) {
          url += '?packages=' + encodeURIComponent(moduleSettings.defaultPackages.join('&'));
        }
        
        window.location.href = url;
      });
    }
  };

})(jQuery, Drupal); 