(function ($, Drupal, once) {
  function generateGraph() {
    const selectedType = $('#change_graph_type').find(':selected');
    const matomoUrl = $('#matomo_url');
    const token = $('#token');
    const siteId = $('#site_id');
    const segment = $('#segment');

    let apiModule = '';
    let apiAction = '';

    switch (selectedType.val()) {
      case 'visits':
        apiModule = 'VisitsSummary';
        apiAction = 'get';
        break;

      case 'browsers':
        apiModule = 'DevicesDetection';
        apiAction = 'getBrowsers';
        break;

      case 'countries':
        apiModule = 'UserCountry';
        apiAction = 'getCountry';
        break;

      case 'os':
        apiModule = 'DevicesDetection';
        apiAction = 'getOsVersions';
        break;

      case 'resolutions':
        apiModule = 'Resolution';
        apiAction = 'getResolution';
        break;

      default:
        apiModule = 'Actions';
        apiAction = 'get';
        break;
    }

    // eslint-disable prefer-template
    const src = `${matomoUrl.val()} / ? module = API & method = ImageGraph.get & idSite = ${siteId.val()} & apiModule = ${
      apiModule
    } & apiAction = ${
      apiAction
    } & token_auth = ${token.val()} & period = day & date = previous30 & segment = ${segment.val()}`;
    // eslint-enable prefer-template

    $('#mom_graph').attr('src', src);
  }

  Drupal.behaviors.mom = {
    function (context, settings) {
      generateGraph();

      $(once('mom', '#change_graph_type', context)).on('change', function () {
        generateGraph();
      });
    },
  };
})(jQuery, Drupal, once);
