# Matomo on-page metrics (mom) - Quick start guide

This guide provides a quick overview of what is required to get the Matomo
On-page Metrics module working.

1. Ensure that the **Matomo Reporting API** module is **installed** and *
   *enabled** (https://www.drupal.org/project/matomo_reporting_api). You
   can run this command to add the module, also remember to enable it in Drupal.
   ```
   composer require drupal/matomo_reporting_api
   ```
2. Copy / clone the Matomo on-page metrics module code into the modules/custom
   folder.
3. **Enable** the Matomo on-page metrics module.
4. Clear the cache
5. Apply the **Matomo Authentication token** - this should ideally be saved in
   the environment settings code instead of on the Matomo Reporting API form
   using Drupal user interface - this authentication code should rather be
   stored in a location where it is not handled by git for security reasons.
   Here is an example of how this could be configured in a settings file (The
   '###' represents your Matomo auth token):
   ```php
   $config['matomo_reporting_api.settings']['token_auth'] = '###';
   ```
   Nonetheless, this token can be entered on the Matomo Reporting API settings
   page, but it is considered best practice to declare the token in code as
   explained above.

   If this authentication token has not been set the Matomo on-page metrics
   modal will display an error message stating that the Matomo settings are not
   correct.
6. Update the module settings - this can be done in the Drupal admin settings:
   * By navigating to
   *your_site_url/__admin/config/mom/adminsettings__*
   * By opening the Matomo on-page metrics modal for the first time and clicking
   on the "Matomo on-page metrics settings" link.

**Important Note** - This module makes use of the **Drupal Modal** module which
may not be compatible with all themes. Additionally, the Drupal Modal module
requires **jQuery 1.7** or higher.

**Credits**

This module makes use of Bootstrap Grid Only available at
https://www.jsdelivr.com/package/npm/bootstrap-v4-grid-only
