(function ($, Drupal, once) {
  Drupal.behaviors.matomoOnpageMetrics = {
    attach: function (context, settings) {
      generateGraph();

      $(once('matomoOnpageMetrics', '#change_graph_type', context)).on('change', function () {
        generateGraph();
      });
    }
  };

  function generateGraph() {
    let selectedType = $('#change_graph_type').find(':selected').val();
    let matomo_url = $('#matomo_url').val();
    let token = $('#token').val();
    let site_id = $('#site_id').val();
    let segment = $('#segment').val();

    let apiModule = '';
    let apiAction = '';

    switch (selectedType) {
      default:
        apiModule = 'Actions';
        apiAction = 'get';
        break;

      case 'visits':
        apiModule = 'VisitsSummary';
        apiAction = 'get';
        break;

      case 'browsers':
        apiModule = 'DevicesDetection';
        apiAction = 'getBrowsers';
        break;

      case 'countries':
        apiModule = 'UserCountry';
        apiAction = 'getCountry';
        break;

      case 'os':
        apiModule = 'DevicesDetection';
        apiAction = 'getOsVersions';
        break;

      case 'resolutions':
        apiModule = 'Resolution';
        apiAction = 'getResolution';
        break;
    }

    let src = matomo_url + '/?module=API&method=ImageGraph.get&idSite=' + site_id + '&apiModule=' + apiModule + '&apiAction=' + apiAction + '&token_auth=' + token + '&period=day&date=previous30&segment=' + segment;

    $('#matomo_onpage_metrics_graph').attr('src', src);
  }
})(jQuery, Drupal, once);
