<?php

/**
 * @file
 * Contains \Drupal\monitoring\Form\MonitoringSettingsForm.
 */

namespace Drupal\monitoring\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form for general Monitoring configuration.
 */
class MonitoringSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'monitoring_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['monitoring.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('monitoring.settings');

    $options = [
      'all' => $this->t('Log all events'),
      'on_request' => $this->t('Log only on request or on status change'),
      'none' => $this->t('No logging'),
    ];
    $form['sensor_call_logging'] = array(
      '#title' => $this->t('Monitoring event logging'),
      '#type' => 'select',
      '#options' => $options,
      '#default_value' => $config->get('sensor_call_logging'),
      '#description' => $this->t('Control local logging of sensor call results.'),
    );
    $form['watchdog_logging'] = [
      '#title' => $this->t('Also log events to the regular log (watchdog)'),
      '#type' => 'checkbox',
      '#default_value' => $config->get('watchdog_logging'),
      '#description' => $this->t('By default, logs are stored as a custom entity. Enable this to also send them to the regular watchdog, respects the setting when logs are created.'),
    ];
    $form['cron_run_sensors'] = [
      '#title' => $this->t('Run sensors during cron runs'),
      '#type' => 'checkbox',
      '#default_value' => $config->get('cron_run_sensors'),
      '#description' => $this->t('In this mode, monitoring will not be able to detect if cron is running. It is recommended to fetch sensor results with drush or through REST requests for a more reliable setup.'),
    ];
    $form['disable_sensor_autocreate'] = [
      '#title' => $this->t('Disable sensor auto creation'),
      '#type' => 'checkbox',
      '#default_value' => $config->get('disable_sensor_autocreate'),
      '#description' => $this->t('Disable automatic sensor creation. For example: sensors are normally added when node types are added, or new modules are installed.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('monitoring.settings')
      ->set('sensor_call_logging', $form_state->getValue('sensor_call_logging'))
      ->set('watchdog_logging', $form_state->getValue('watchdog_logging'))
      ->set('cron_run_sensors', $form_state->getValue('cron_run_sensors'))
      ->set('disable_sensor_autocreate', $form_state->getValue('disable_sensor_autocreate'))
      ->save();
  }

}
