# Monitoring Endpoint

This module provides a secure JSON endpoint that exposes the status of all enabled sensors from the Monitoring module. It's designed for integration with external monitoring tools and services.

It was inspired by https://www.drupal.org/project/monitoring_hrm

## Table of Contents

- [Features](#features)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Monitoring Status Codes](#monitoring-status-codes)
- [Cron Jobs Monitoring](#cron-jobs-monitoring)
- [Security Considerations](#security-considerations)
- [Integration Examples](#integration-examples)
- [Maintainers](#maintainers)

## Features

- Secure token-based authentication for API access
- JSON-formatted output compatible with external monitoring tools
- Real-time status reporting of all enabled monitoring sensors
- Individual Ultimate Cron job monitoring and status reporting
- Cacheable responses for performance optimization
- Integration with standard Drupal monitoring infrastructure

## Requirements

This module requires the following:

- Drupal core: ^10.2 || ^11
- PHP: 8.1 or higher
- [Monitoring](https://www.drupal.org/project/monitoring) module (required)
- [Ultimate Cron](https://www.drupal.org/project/ultimate_cron) module (optional, for cron job monitoring features)

## Installation

Install this module as you would normally install a contributed Drupal module.

**Using Composer (recommended):**
```bash
composer require drupal/monitoring_endpoint
drush en monitoring_endpoint -y
```

**Manual Installation:**
1. Download the module from https://www.drupal.org/project/monitoring_endpoint
2. Extract the archive to your Drupal modules directory (e.g., `modules/contrib/`)
3. Enable the module through the admin interface or with Drush

For more information, see [Installing contributed modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

### Setting the Endpoint Key

There is currently no configuration UI. Configure access to the endpoint by setting a secure token in your `settings.php` file:

```php
$config['monitoring_endpoint.settings']['endpoint_key'] = 'your-secure-random-token-here';
```

**Important:** Change the default token immediately after installation. Use a strong, randomly generated string (at least 32 characters).

To generate a secure token, you can use:
```bash
# Linux/macOS
openssl rand -base64 32

# Or using PHP
php -r "echo bin2hex(random_bytes(32));"
```

Alternatively, you can export the configuration and edit it manually through your configuration management workflow.

## Usage

Once configured, access the monitoring endpoint at:

```
https://yoursite.example.com/monitoring/status?token=your-secure-random-token-here
```

### Response Format

The endpoint returns a JSON response with the following structure:

```json
{
  "count_failures": 1,
  "sensor_id_1": "OK",
  "sensor_id_2": "CRITICAL",
  "sensor_id_3": "WARNING",
  "cron_job_example_job": "OK"
}
```

Where:
- `count_failures` - The total number of sensors in CRITICAL state
- Each sensor or monitored cron job is listed with its current status

## General Monitoring

1. Navigate to **Configuration > System > Monitoring > Sensors** (`/admin/config/system/monitoring/sensors`)
2. Enable and configure the sensors you want to monitor
3. The endpoint will automatically include all enabled sensors in its response

The endpoint responds with a JSON payload that includes:
- A count of critical failures (`count_failures`)
- The status of each enabled monitoring sensor
- Individual cron job statuses (if Ultimate Cron is enabled and jobs are configured for monitoring)

## Monitoring Status Codes

All sensors use the standard Monitoring module status codes:
- `OK` - Everything is functioning correctly
- `WARNING` - There's a potential issue that might require attention
- `CRITICAL` - There's a critical issue that requires immediate attention
- `INFO` - Informational status only

## Cron Jobs Monitoring

This module provides the ability to monitor individual Ultimate Cron jobs and report their status through the monitoring endpoint.

### How to enable monitoring for specific cron jobs

1. Navigate to the Ultimate Cron jobs listing page: `/admin/config/system/cron/jobs`
2. Click on the cron job you want to monitor
3. On the edit form, you will see a checkbox labeled "Monitor this cron job" right below the "Enabled" checkbox
4. Check this box and save the form
5. Repeat for each cron job you want to monitor

### How it works

- When you mark a cron job for monitoring, it's saved in the module's configuration (`monitoring_endpoint.settings.monitored_cron_jobs`)
- A sensor checks the status of each monitored cron job during monitoring runs
- In the monitoring/status endpoint output, each monitored cron job appears as a separate line with its status:
  - `cron_job_[job_id]: OK` - The job is running properly
  - `cron_job_[job_id]: WARNING` - The job is disabled or has never been executed
  - `cron_job_[job_id]: CRITICAL` - The job failed during its last execution
- The overall monitoring status reflects the worst status among all cron jobs

## Security Considerations

### Token Security

- **Always use a strong, random token** - Never use predictable values like "secret", "password", or site-specific information
- **Keep the token secret** - Do not commit your `settings.php` file with the token to public repositories
- **Use environment variables** - Consider storing the token in environment variables for better security:
  ```php
  $config['monitoring_endpoint.settings']['endpoint_key'] = getenv('MONITORING_ENDPOINT_KEY');
  ```
- **Rotate tokens periodically** - Change the token regularly as part of your security practices
- **Monitor access logs** - Watch your web server logs for unauthorized access attempts to the endpoint

### HTTPS

Always use HTTPS when accessing the endpoint to prevent token interception. The token is passed as a URL parameter, making it vulnerable to eavesdropping on unencrypted connections.

### Access Control

The endpoint bypasses Drupal's standard permission system and relies solely on token authentication. Ensure your token is sufficiently long and random to prevent brute-force attacks.

### Firewall Configuration

Consider restricting access to the endpoint at the firewall level to only allow requests from known monitoring server IP addresses.

## Integration Examples

### cURL
```bash
curl "https://yoursite.example.com/monitoring/status?token=your-secure-token"
```

### Using with monitoring services

The JSON response format is designed to be compatible with various monitoring tools:

- **Nagios/Icinga**: Parse the `count_failures` value to determine overall status
- **Uptime Kuma**: Tested and working. Configure with:
  - Monitor Type: `HTTP(s) - Json Query`
  - Json Query: `$.cron_job_abc_api_import_cron_jobs` (or any sensor/cron job from the response)
  - Expected Value: `OK`
- **Custom scripts**: Parse the JSON response in any programming language


