<?php

declare(strict_types=1);

namespace Drupal\monitoring_endpoint\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Check if a token is present in GET args.
 */
class MonitoringEndpointAccessCheck implements AccessInterface {

  /**
   * Name of a GET param to get the key.
   */
  protected const KEY_NAME = 'token';

  /**
   * Constructs a new MonitoringEndpointAccessCheck.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   Config factory.
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Determine access for the endpoint.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The incoming HTTP request object.
   *
   * @return \Drupal\Core\Access\AccessResult
   *   An access result.
   */
  public function access(Request $request): AccessResult {
    $settings = $this->configFactory->get('monitoring_endpoint.settings');
    $expectedKey = $settings->get('endpoint_key');
    $userKey = $request->query->get(static::KEY_NAME);

    return AccessResult::allowedIf(is_string($userKey) && $userKey === $expectedKey)
      ->addCacheContexts(['url.query_args:' . static::KEY_NAME])
      ->addCacheableDependency($settings);
  }

}
