<?php

namespace Drupal\monitoring_endpoint\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Monitoring Endpoint settings.
 */
class MonitoringEndpointSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['monitoring_endpoint.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'monitoring_endpoint_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('monitoring_endpoint.settings');

    $form['enable_cache'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable cache'),
      '#description' => $this->t('Enable this option to cache the monitoring endpoint responses. By default, caching is disabled to ensure that external monitoring tools always receive real-time data. Note: The endpoint is protected by token authentication and typically accessed by authorised monitoring tools only.'),
      '#default_value' => $config->get('enable_cache') ?? FALSE,
    ];

    $form['endpoint_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Endpoint access key'),
      '#description' => $this->t('A secure token to authenticate requests to the monitoring endpoint. It is recommended to set this in settings.php instead for better security.'),
      '#default_value' => $config->get('endpoint_key'),
      '#maxlength' => 255,
    ];

    $form['security_notice'] = [
      '#type' => 'item',
      '#markup' => '<div class="messages messages--warning">' . $this->t('<strong>Security Note:</strong> For production environments, it is highly recommended to set the endpoint_key in your settings.php file instead of using this form. This prevents the key from being exported with your configuration.') . '</div>',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('monitoring_endpoint.settings')
      ->set('enable_cache', $form_state->getValue('enable_cache'))
      ->set('endpoint_key', $form_state->getValue('endpoint_key'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
