<?php

namespace Drupal\monitoring_endpoint\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a RouteSubscriber object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * Alters existing routes to modify their behavior based on configuration.
   *
   * This method checks the `enable_cache` setting from the module's
   * configuration.
   * If caching is not enabled (`enable_cache` is FALSE), it sets the `no_cache`
   * option to TRUE for the `monitoring_endpoint.endpoint` route. This ensures
   * that the endpoint does not use cached responses, providing real-time data.
   *
   * @param \Symfony\Component\Routing\RouteCollection $collection
   *   The collection of routes to be altered.
   */
  protected function alterRoutes(RouteCollection $collection) {
    $config = $this->configFactory->get('monitoring_endpoint.settings');
    $enable_cache = $config->get('enable_cache');

    if ($route = $collection->get('monitoring_endpoint.endpoint')) {
      // If cache is not enabled, set no_cache to TRUE.
      if (!$enable_cache) {
        $route->setOption('no_cache', TRUE);
      }
    }
  }

}
