(function ($, Drupal, drupalSettings) {
  if (typeof(Drupal.mmgroupTable) == 'undefined') Drupal.mmgroupTable = [];

  Drupal.behaviors.MMUserDataTable = {
    attach: function (context, settings) {
      var $elem = $('#mm-user-datatable-' + settings.MM.group_table.id_name, context);
      once('mm-user-datatable', $elem).forEach(function () {
        Drupal.mmgroupTable[settings.MM.group_table.clean_element] = $elem.DataTable({
          columns:      settings.MM.group_table.col_def,
          processing:   true,
          serverSide:   true,
          pageLength:   20,
          lengthChange: false,
          ajax:         { url: settings.MM.group_table.load },
          language: {
            infoFiltered: Drupal.t('(filtered from _MAX_)'),
            entries: {
              _: 'users',
              1: 'user'
            }
          }
        });
      });
    }
  };

  Drupal.mmGroupRemoveUser = function (uid, element) {
    $.ajax({
      url:     drupalSettings.MM.group_table.delete.replace('-USER-', uid),
      async:   false,
      success: function () {
        Drupal.mmgroupTable[element].draw();
      }
    });
  };

  Drupal.mmGroupAddUser = function (mmListObj) {
    var uids;
    if (mmListObj.length && (uids = mmListObj.val())) {
      $.ajax({
        url:     drupalSettings.MM.group_table.add.replace('-UIDS-', uids.replace(/\{.*?\}/g, ',').replace(/,$/, '')),
        async:   false,
        success: function () {
          Drupal.mmDialogClose();
          mmListObj[0].mmList.delAll();
          $(mmListObj[0].mmList.p.autoComplete).val('');
          Drupal.mmgroupTable['members'].draw();
        }
      });
    }
    else {
      Drupal.mmDialogClose();
    }
    return false;
  };
})(jQuery, Drupal, drupalSettings);