(function ($, Drupal, drupalSettings) {
  class mmList {
    dialogInstance = 1000;
    p;
    oneRow;
    rowTag;
    selectedObj;
    editReplace;
    nRow = 0;

    constructor(parms, reInit) {
      this.p = parms;

      function getPf(node) {
        return $(node).closest('.mm-list-accordion').find('input.mm-list-hidden')[0].mmList;
      }

      if (reInit) {
        return;
      }

      this.oneRow = parms.minRows <= 1 && parms.maxRows === 1;
      this.rowTag = $(parms.rowSelector, parms.outerDiv.parent()).remove().show();

      if (parms.minRows > 0 && !parms.isSearch) {
        parms.outerDiv.siblings('label').addClass('form-required');
      }

      if (!parms.flags.readonly) {
        var summ = this.rowTag.find('summary');
        // Edit button.
        if (parms.flags.useEditButton) {
          this.getButton(Drupal.t('Edit'), {class: 'mm-list-button-edit'})
            .prependTo(summ);
        }
        if (parms.maxRows !== 1 || parms.minRows === 0) {
          // Add button.
          this.getButton(Drupal.t('Add'), {class: 'mm-list-button-add'})
            .appendTo(parms.outerDiv)
            .click(function () {
              var pf = getPf(this);
              pf.editReplace = null;
              if (parms.flags.addOpensTreeBrowser) {
                pf.openWind(parms.popupURL);
              }
              else {
                pf.addItem(true);
              }
              return false;
            });
          // Delete button.
          this.getButton(Drupal.t('Delete'), {class: 'mm-list-button-delete'})
            .prependTo(summ);
          // Drag to reorder link (button doesn't work with Sortable).
          if (parms.flags.reorder) {
            $('<a/>').text(Drupal.t('Drag to reorder')).addClass('mm-list-button-reorder')
              .prependTo(summ);
            var that = this;
            Sortable.create(parms.outerDiv[0], {
              containment:   parms.outerDiv[0],
              direction:     'vertical',
              forceFallback: true,
              handle:        '.mm-list-button-reorder',
              animation:     100,
              onChoose:      function() {that.setSelected();},
              onUpdate:      function() {that.setHiddenElt();}
            });
          }
        }
      }

      // Info
      if (parms.labelAboveInfo || parms.infoConst) {
        $('<div class="info" />')
          .append($('<label />')
            .html(parms.labelAboveInfo))
          .append($('<div class="description" />'))
          .appendTo(this.rowTag.find('.details-wrapper'));
      }

      parms.outerDiv
        // Toggle details.
        .on('click', 'summary', null, function (event) {
          if (!event.target.nodeName.match(/INPUT|OPTION|SELECT/)) {
            var pf = getPf(this);
            event.preventDefault();
            var clicked = $(this).closest('details');
            pf.setSelected(clicked.attr('open') === 'open' ? undefined : clicked);
          }
          return false;
        }, false)
        // Delete button.
        .on('click', '.mm-list-button-delete:enabled', null, function (event) {
          var pf = getPf(this);
          if (event.shiftKey || !parms.delConfirmMsg || confirm(parms.delConfirmMsg)) {
            pf.deleteRow($(this).closest('details'));
          }
          return false;
        }, false)
        // Edit button.
        .on('click', '.mm-list-button-edit:enabled', null, function (event) {
          var pf = getPf(this);
          var row = $(this).closest('details');
          pf.setSelected(row);
          pf.editReplace = row;
          pf.openWind(row[0].mmListArgs[2] || pf.p.popupURL);
          return false;
        }, false);
    }

    getButton(label, attr) {
      attr = attr || false;
      return $('<input type="button" />')
        .attr(attr)
        .attr('title', label);
    }

    addItem(select) {
      var nrows = this.p.outerDiv.children('details').length;
      if (this.p.maxRows > 0 && nrows >= this.p.maxRows) {
        return;
      }
      var row = this.rowTag.clone(true);
      row[0].mmListArgs = [];
      for (var i = arguments.length; --i >= 1;) {
        row[0].mmListArgs[i - 1] = arguments[i];
      }
      if (this.p.addCallback) {
        this.p.addCallback(this, row);
      }
      var summ = row.find('summary');
      var id = summ.attr('aria-controls') + this.nRow++;
      summ.attr('aria-controls', id);
      if (this.p.flags.reorder) {
        // Avoid a bug in Sortable.
        summ.addClass('mm-list-prevent-selection');
      }
      row.attr('id', id);

      var info = this.p.infoCallback ? this.p.infoCallback(this, row) : '';
      $('.info .description', row).html(info);

      nrows ? row.insertAfter(this.p.outerDiv.children('details').last()) : row.prependTo(this.p.outerDiv);

      if (select) {
        this.enableOpts();
      }
      if (!this.p.isSearch || row.is(':visible')) {
        $('.mmsr-autocomplete', row).addClass('form-autocomplete');
        this.addAutocomplete(row);
      }
      this.setHiddenElt(true);

      this.setSelected(this.oneRow || select ? row : undefined);
    }

    submitOnAdd(obj) {
      if (this.p.flags.submitOnAdd) {
        if (obj) {
          var popup = obj.popup;
          if (popup) {
            obj.popup = null;
            $(popup).remove();
          }
          obj.selected = false;
        }
        var form = this.p.outerDiv.closest('form');
        var button = form.find(':button:not([class^="mm-list-button-"])');
        if (button.length === 1) {
          button.click();
        }
        else {
          button = form.find('.form-actions :submit:first');
          button.length ? button.click() : form.submit();
        }
      }
    }

    enableOpts() {
      if (this.p.maxRows > 0) {
        $('.mm-list-button-add', this.p.outerDiv).attr('disabled', this.p.outerDiv.children('details').length >= this.p.maxRows);
      }
      var buttons = this.p.outerDiv.find('.mm-list-button-delete');
      buttons.attr('disabled', this.p.minRows > 0 && buttons.length <= this.p.minRows);
      this.p.outerDiv.find('.mm-list-button-reorder')
        .attr('disabled', buttons.length == 1);
    }

    setSelected(obj, done) {
      if (this.selectedObj && obj ? !this.selectedObj.is(obj) : this.selectedObj !== obj) {
        this.selectedObj = obj;
        var p = this.p;
        $(p.outerDiv)
          .children('details')
          .each(function () {
            var details = $(this);
            var toOpen = obj && details.is(obj);
            var isOpen = details.attr('open') === 'open';
            if (toOpen !== isOpen) {
              var wrap = details.find('.details-wrapper');
              if (toOpen) {
                wrap.hide();
                details.attr('open', 'open');
                if (wrap.text()) {
                  wrap.slideDown(250, done);
                }
                if (p.flags.initialFocus) {
                  $('[name="' + p.flags.initialFocus + '"]:first', obj).focus().select();
                }
              }
              else {
                wrap.slideUp(250, function () {
                  details.attr('open', null);
                  if (done) {
                    done();
                  }
                });
              }
              details.find('summary')
                .attr('aria-expanded', toOpen ? 'true' : 'false');
            }
          });
      }
      else if (done) {
        done();
      }
    }

    deleteRow(row) {
      if (this.p.minRows > 0 && this.p.outerDiv.children('details').length <= this.p.minRows) {
        $(':input:not(:checkbox):not(:button):not(:submit)', row).val('');
        row[0].mmListArgs = [ Drupal.t('(choose)'), '', '', '' ];
        var ret = this.p.replaceCallback(this.pf, row);
        var info = row.find('.info .description').html(ret);
        if (ret === '') {
          info.hide();
        }
      }
      else {
        row.remove();
        this.setSelected();
        this.enableOpts();
      }
      this.setHiddenElt();
    }

    addFromChild(obj, info, node, name) {
      if (!obj) {
        return;
      }

      var url = [ obj.id.substring(5) ];
      var longPath = [ $('a:first', obj).html().replace(/<(\w+).*?>.*?<\/\1>/g, '').replace(/^[\s\xA0]+/, '').replace(/[\s\xA0]+$/, '') ];
      $(obj).parents('li[id^=mmbr-]').each(function() {
        url.unshift(this.id.substring(5));
        longPath.unshift($('a:first', this).html().replace(/<(\w+).*?>.*?<\/\1>/g, '').replace(/^[\s\xA0]+/, '').replace(/[\s\xA0]+$/, ''));
      });

      if (!isNaN(info)) {
        info = longPath.join('&nbsp;&raquo; ');
      }

      Drupal.mmDialogClose();
      var pf = this;
      var path = url.join('/');
      var found = null;
      var arg1 = pf.p.flags.isRssList ? 'cat' : url[url.length - 1];
      if (node) {
        arg1 += '/' + node;
      }
      else if (!name) {
        name = longPath[longPath.length - 1];
      }
      this.p.outerDiv
        .children('details')
        .not(pf.editReplace)
        .each(function() {
          var details = $(this);
          if (pf.p.flags.isRssList ? this.mmListArgs[0] === arg1 && this.mmListArgs[2] === path : this.mmListArgs[1] === url[url.length - 1]) {
            pf.setSelected(found = details);
            pf.animateDup(found);
            return false;
          }
        });

      if (!found) {
        if (this.editReplace) {
          if (this.p.replaceCallback) {
            var args = pf.p.flags.isRssList ? [arg1, name] : [name, arg1];
            this.editReplace[0].mmListArgs = args.concat([url.join('/'), info]);
            this.editReplace.find('.info .description')
              .html(this.p.replaceCallback(this.pf, this.editReplace));
          }
          this.setSelected(this.editReplace);
          this.editReplace = null;
        }
        else {
          this.addItem(true, name, arg1, path, info);
        }
        this.setHiddenElt();
        this.submitOnAdd();
      }
    }

    animateDup(found) {
      setTimeout(function () {
        var old = found.css('background-color');
        found.css('background-color', '#ff5').fadeTo(200, 0.25).fadeTo(200, 1).fadeTo(200, 0.25).fadeTo(200, 1).fadeTo(200, 0.25).fadeTo(200, 1, function () {
          found.css('background-color', old);
        });
      }, 250);
    }

    setHiddenElt(init) {
      var count = 0;
      var val = '';
      var pf = this;
      pf.p.outerDiv
        .children('details')
        .each(function() {
          var ret;
          if (ret = pf.p.dataCallback(pf, $(this))) {
            val += ret;
            count++;
          }
        });
      if (!this.p.flags.readonly) {
        pf.p.hiddenElt
          .val(val)
          .trigger('change');
        if (count) {
          if (pf.p.updateOnChangeName) {
            var elt = $('[name="' + pf.p.updateOnChangeName + '"]');
            if (elt.length) {
              if (elt[0].type === 'checkbox') {
                elt[0].checked = 0;
              }
              else {
                elt[0].value = '';
              }
            }
          }
        }
        window.mmListInstance = null;
      }
      if (typeof(pf.p.updateOnChangeCallback) == 'function') {
        pf.p.outerDiv
          .children('details')
          .each(function() {
            pf.p.updateOnChangeCallback(pf, $(this), init);
          });
      }
    }

    openWind(url) {
      window.mmListInstance = this;
      Drupal.mmDialogAdHoc(this.p.popupBase + url, this.p.popupLabel, {iframe: true, fullSize: true});
    }

    addAutocomplete(obj) {
      var parms = this.p;
      if (Drupal.autocomplete && parms.autoComplete) {
        var auto_obj, valid_val;
        var pf = this;

        auto_obj = $(parms.autoComplete, obj).addClass('form-autocomplete');
        if (!auto_obj.data('ui-autocomplete')) {
          auto_obj.autocomplete(Drupal.autocomplete.options);
        }
        auto_obj
          .on('focus', function(event) {
            valid_val = event.target.value;
            pf.setSelected($(event.target).closest('details'));
          })
          .on('blur', function(event) {
            // If not empty, reset it to the last good value.
            if (event.target.value) {
              event.target.value = valid_val;
            }
          })
          .autocomplete('option', 'select', function (event, ui) {
            if (parms.autocompleteCallback) {
              var v = parms.autocompleteCallback(pf, $(event.target).closest('details'), event, ui);
              if (v) {
                valid_val = v;
              }
              // Return false to tell jQuery UI that we've filled in the value already.
              return false;
            }
          })
          .autocomplete('option', 'search',
            function(event) {
              // Only search when the term is at least the minimum length of 2.
              return event.target.value.length >= parms.autoComplete ? 2 : 1;
            }
          );
      }
    }

    // Called by external onclick events, like when user clicks on a checkbox elsewhere on the form.
    delAll() {
      if (this.oneRow) {
        this.deleteRow(this.selectedObj);
      }
      else {
        var p = this;
        $('details', this.p.outerDiv).each(function () {
          p.deleteRow($(this));
        });
        this.setSelected();
      }
    }
  }

  Drupal = $.extend(true, Drupal, {
    mmListCallbacks: {
      //------- Category callbacks -------
      catAddCallback: function (pf, row) {
        // args: 0=text, 1=mmtid, 2=url, 3=longPath
        Drupal.mmListCallbacks.catReplCallback(pf, row);
      },
      catInfoCallback: function (pf, row) {
        return pf.p.infoConst || row[0].mmListArgs[3];
      },
      catReplCallback: function (pf, row) {
        $('summary span.summary:first', row).html(row[0].mmListArgs[0]);
        return row[0].mmListArgs[3];
      },
      catDataCallback: function (pf, row) {
        if (!row[0].mmListArgs[1]) {
          return false;
        }
        return row[0].mmListArgs[1] + '{' + row[0].mmListArgs[0] + '}';
      },
      catAutocompleteCallback: function(pf, row, event, ui) {
        var ac_val = ui.item.value;
        var i = ac_val.indexOf('-');
        if (i > 0) {
          var name = ac_val.substring(i + 1);
          var mmtid = ac_val.substring(0, i);
//          event.target.value = '';
          var found = null;
          $(pf.p.outerDiv)
            .children('details')
            .not(row)
            .each(function() {
              if (this.mmListArgs[1] === mmtid) {
                found = $(this);
                return name;
              }
            });
          if (found) {
            pf.setSelected(found);
            pf.animateDup(found);
            return name;
          }

          row[0].mmListArgs = [name, mmtid, '', ''];
          if (pf.p.replaceCallback) {
            pf.p.replaceCallback(pf, row);
          }
          pf.setHiddenElt();
          pf.submitOnAdd();
          $(pf.p.outerDiv)    // update any details summary
            .closest('details.vertical-tabs__pane')
            .add('details#edit-settings-perms')
            .trigger('summaryUpdated');
          return name;
        }
      },

      //------- Category callbacks -------
      userAddCallback: function (pf, row) {
        // args: 0=text, 1=mmtid, 2=url, 3=longPath
        Drupal.mmListCallbacks.userReplCallback(pf, row);
      },
      userReplCallback: function (pf, row) {
        $('summary input[type="text"]', row).val(row[0].mmListArgs[0]);
        return row[0].mmListArgs[3];
      },
    },
    mmListGetObj: function (where, instance) {
      var outerDiv = instance.parms.outerDiv = $(instance.parms.outerDivSelector, where);
      if (!outerDiv.length) {
        return;
      }

      instance.parms.hiddenElt = $('<input type="hidden" id="' + instance.hiddenId + '" name="' + instance.hiddenName + '" class="mm-list-hidden" />')
        .appendTo(outerDiv);
      instance.parms.autoComplete = instance.autoName ? 'input[name^="' + instance.autoName + '"]' : null;

      if (!instance.parms.outerDiv.length || !instance.parms.hiddenElt) {
        return;
      }

      $.each(['addCallback', 'replaceCallback', 'infoCallback', 'dataCallback', 'updateOnChangeCallback', 'autocompleteCallback'], function(key, callback) {
        if (instance.parms[callback] && typeof instance.parms[callback] !== 'function') {
          instance.parms[callback] = Drupal.mmListCallbacks[instance.parms[callback]];
        }
      });

      return instance.parms.hiddenElt[0].mmList = new mmList(instance.parms);
    },

    MMListReinit: function(where, instance) {
      var p = jQuery.extend(true, {}, instance.p);
      p.outerDiv = $(instance.p.outerDivSelector, where);
      p.hiddenElt = $('input.mm-list-hidden', p.outerDiv);
      var mmlist = p.hiddenElt[0].mmList = new mmList(p, true);
      mmlist.rowTag = instance.p.hiddenElt[0].mmList.rowTag;
      $('details', p.outerDiv).each(function() {
        var row = $(this);
        $('.mmsr-autocomplete', row).addClass('form-autocomplete');
        mmlist.addAutocomplete.apply(mmlist, row);
      })
    }
  });

  Drupal.behaviors.mmListInit = {
    attach: function (context) {
      $(once('mm-template', '.mm-template'))
        .each(function() {
          $('body').append(this.innerHTML);
        });

      $.each(drupalSettings.MM.mmListInit, function(key, instance) {
        if (instance && !instance.inited) {
          // Clone parms so that changes at lower levels don't affect other instances.
          instance.parms = jQuery.extend(true, {}, instance.parms);
          var obj = Drupal.mmListGetObj(context, instance);
          if (obj) {
            instance.inited = true;
            $.each(instance.add, function(key, list) {
              list.unshift(false);
              obj.addItem.apply(obj, list);
            });
            obj.enableOpts();
            if (typeof Drupal.behaviors.AJAX !== 'undefined') {
              Drupal.behaviors.AJAX.attach(instance.parms.outerDiv[0], drupalSettings);
            }
            if (instance.parms.autoChoose) {
              // Pause a moment so that the main dialog can fully initialize before the modal opens.
              setTimeout(function() {$('.mm-list-button-edit:first', obj.p.outerDiv).click()}, 500);
            }
          }
        }
      });
    }
  };

})(jQuery, Drupal, drupalSettings);
