(function ($, Drupal) {
  Drupal = $.extend(true, Drupal, {
    mmListCallbacks: {
      listAddCallback: function (pf, row) {
        if (!pf.p.flags.readonly) {
          var map = {}, names = {};
          $(':input,.description', row).each(function() {
            var a, obj = $(this);
            ['id', 'name'].forEach(function(attr) {
              if (a = obj.attr(attr)) {
                var n = a + '__r' + pf.nRow;
                obj.attr(attr, n);
                map[a] = n;
                if (attr === 'name') {
                  names[a] = 1;
                }
              }
            });
          });
          $(':input,label', row).each(function() {
            var a, obj = $(this);
            ['for', 'aria-describedby'].forEach(function(attr) {
              if ((a = obj.attr(attr)) && map[a]) {
                obj.attr(attr, map[a]);
              }
            });
          });
          // Create an empty parameter for each named input, when necessary.
          var len = Object.keys(names).length - row[0].mmListArgs.length;
          if (len > 0) {
            row[0].mmListArgs.push(...new Array(len).fill(''));
          }

          row.on('change.mm-catlist', ':input:not([class^="mm-list-button-"])', function () {
            if (this.type === 'checkbox') {
              row[0].mmListArgs[this.argsIndex] = this.checked ? this.value : '';
            }
            else if (this.type !== 'radio' || this.checked) {
              row[0].mmListArgs[this.argsIndex] = this.value;
            }
            pf.setHiddenElt();
            return true;
          });
        }
      },

      listDataCallback: function (pf, row) {
        if (!row[0].mmListArgs.length) {
          return '';
        }
        return '{:' + row[0].mmListArgs.join(':}{:') + ':}';
      },

      listUpdateOnChangeCallback: function (pf, row, init) {
        var radios = {}, label = [], argsInd = -1;
        var isReadOnly = pf.p.flags.readonly;
        var args = row[0].mmListArgs;
        $(':input:not([class^="mm-list-button-"]),.mm-list-info', row).each(function () {
          if ($(this).parents('.mm-list-hidden').length) {
            return;
          }
          var ro = '';

          if (this.type === 'radio') {
            if (typeof radios[this.name] === 'undefined') {
              radios[this.name] = ++argsInd;
            }
            this.argsIndex = radios[this.name];
            if (init) {
              this.checked = args[argsInd] === this.value;
            }
            if (args[argsInd] === this.value) {
              ro =  $(this).next('label').text();
            }
          }
          else {
            this.argsIndex = ++argsInd;
            if (this.type === 'checkbox') {
              ro = args[argsInd] !== '' ?  $(this).next('label').text() : '';
              if (init) {
                this.checked = args[argsInd] !== '';
              }
            }
            else {
              if (init) {
                var v = args[argsInd] || '';
                if (this.tagName === 'DIV') {
                  this.innerText = v;
                }
                else {
                  this.value = v;
                }
              }

              if (this.tagName === 'SELECT') {
                ro = this.selectedIndex >= 0 ? this.options[this.selectedIndex].innerHTML : '';
              }
              else if (args[argsInd]) {
                ro = args[argsInd];
              }
            }
          }

          if (isReadOnly) {
            $(this).attr('disabled', true);
          }
          if (ro && !$(this).parents('summary').length) {
            label.push(ro);
          }
        });

        if (pf.p.replaceCallback) {
          pf.p.replaceCallback(pf, row);
        }
        else {
          $('summary .summary', row).html(label.join('; '));
        }
      }
    }
  });
})(jQuery, Drupal);
