(function ($, Drupal, drupalSettings) {

$.fn.extend({
  mySerialize: function() {
    var s = [];
    for (var i = 0; i < this.length; i++)
      if (this[i].type === 'select-multiple')
        s.push(this[i].name + '=' + encodeURIComponent(($(this[i]).val() || []).sort().join(',')));
      else if (this[i].type === 'checkbox')
        s.push(this[i].name + '=' + encodeURIComponent(this[i].checked + 0));
      else
        s.push(this[i].name + '=' + encodeURIComponent(this[i].value));
    return s.join('&');
  }
});

const MMSR_CONTENTS=      '0';
const MMSR_PAGES=         '1';
const MMSR_CONT_PAGES=    '2';
const MMSR_GROUPS=        '3';
const MMSR_CONTENTS_PANEL= 0;
const MMSR_PAGES_PANEL=    1;
const MMSR_GROUPS_PANEL=   2;

var MMSR_init_done, MMSR_last_recalc, MMSR_panels;

var MMSR_search_type = function (value) {
  var where = $('#mmsr-where-list');
  // don't use empty() here because it destroys event handlers
  while (where[0].childNodes[0])
    where[0].removeChild(where[0].childNodes[0]);
  // noinspection FallThroughInSwitchStatementJS
  switch (value) {
    case MMSR_CONTENTS:
      where.append(MMSR_panels[MMSR_CONTENTS_PANEL]);
      break;
    case MMSR_CONT_PAGES:
      where.append(MMSR_panels[MMSR_CONTENTS_PANEL]);
//    no break
    case MMSR_PAGES:
      where.append(MMSR_panels[MMSR_PAGES_PANEL]);
      break;
    case MMSR_GROUPS:
      where.append(MMSR_panels[MMSR_GROUPS_PANEL]);
  }
};

var MMSR_where_changed = function () {
  var from = $('form>div#search-' + this.value);
  var widgets = from
    .clone(true)
    .removeClass('hidden')
    .show();
  $('.subpanel-select', widgets)
    .change(MMSR_subpanel_changed)
    .each(MMSR_subpanel_changed);
  var search_changed = function () {
    this.selectedIndex === 1 ? $(this).parent().siblings().show() : $(this).parent().siblings().hide();
  };
  $("[name=search-archive-0]", widgets)
    .change(search_changed)
    .each(search_changed);
  $('.mmsr-widgets', this.parentNode.parentNode.nextSibling)
    .empty()
    .append(widgets)
    .parent()
    .show();
  $(':input:visible,:input[name^=search-archive]', widgets)
    .not('[class^="mm-list-button-"]')
    .change(MMSR_recalculate);
  var oldMMLists = $('.mm-list-hidden', from);
  $('.mm-list-hidden', widgets)
    .each(function (i) {
      Drupal.MMListReinit(widgets, oldMMLists[i].mmList);
    });
  $('.mmsr-autocomplete-mmlist', widgets).addClass('form-autocomplete');
  MMSR_fixupAutocomplete(widgets);
  MMSR_recalculate();
};

var MMSR_plus_clicked = function () {
  var tr = this.parentNode.parentNode;
  var trcopy = $(tr)
    .clone(true);
  var from = $('[name=search-logic]', tr);
  $('[name=search-logic]', trcopy)
    .val(from.val())
    .show();
  var pop, trClass;
  switch (tr.className) {
    case 'mmsr-page-row':
      pop = $('[name=search-page-wheres]', trcopy);
      from = $('[name=search-page-wheres]', tr);
      trClass = 'mmsr-page-row-widgets';
      break;
    case 'mmsr-cont-row':
      pop = $('[name=search-node-wheres]', trcopy);
      from = $('[name=search-node-wheres]', tr);
      trClass = 'mmsr-cont-row-widgets';
      break;
    case 'mmsr-group-row':
      pop = $('[name=search-group-wheres]', trcopy);
      from = $('[name=search-group-wheres]', tr);
      trClass = 'mmsr-group-row-widgets';
      break;
  }
  pop
    .val(from.val());
  $(tr)
    .next()
    .after(trcopy)
    .next()
    .after('<tr class="' + trClass + '"><td class="mmsr-widgets" colspan="2"></td></tr>');
  $(pop)
    .each(MMSR_where_changed);
  $('.mmsr-minus', tr.parentNode)
    .show();
};

var MMSR_minus_clicked = function () {
  var tr = this.parentNode.parentNode;
  var parent = tr.parentNode;
  $(tr)
    .next()
    .remove();
  $(tr)
    .remove();
  if ($('.mmsr-minus', parent).length === 1)
    $('.mmsr-minus:first:visible', parent)
      .hide();
  $('[name=search-logic]:first:visible', parent)
    .hide();
  MMSR_recalculate();
};

var MMSR_subpanel_changed = function () {
  $('[name^=' + this.name + '-]', this.parentNode.parentNode)
    .hide()
    .each(function () {
      $('input', this).addClass('mmsr-ignore');
    }
  );
  $('[name=' + this.name + '-' + this.value + ']', this.parentNode.parentNode)
    .show()
    .each(function () {
      $('input', this)
        .removeClass('mmsr-ignore');
      if (!$(this).hasClass('subpanel-inited')) {
        MMSR_fixupAutocomplete(this);
        $(this).addClass('subpanel-inited');
      }
    }
  );
  MMSR_recalculate();
};

var MMSR_initialize = function (context) {
  if (MMSR_init_done) return;
  Drupal.behaviors.mmListInit.attach(document);
  $('#rightcolumn')
    .hide();    // hide the page's right column (admin menu)
  $('#search-logic,#search-node-type,#search-node-wheres')
    .parent()
    .hide();
  $('#edit-search-group-depth,#edit-search-page-depth')
    .change(MMSR_recalculate);
  $('#edit-search-type')
    .change(
      function () {
        MMSR_search_type(this.value);
        MMSR_recalculate();
      }
    );
  $('.subpanel')
    .hide();
  $('#search-archive div:gt(0)')
    .css('display', 'inline');

  $('#mm-search-form')
    .on('mmsr-change', '[name^=mm_list_obj] input.mm-list-hidden', null, function() {
      var matches = $(this).val().split(/(.*?)\{(.*?)\}/);
      this.mmList.delAll();
      var i = 0;
      var pf = this.mmList;
      pf.p.outerDiv.children('details').each(function () {
        this.mmListArgs = [ matches[i + 2], matches[i + 1], '', '' ];
        if (pf.p.replaceCallback) {
          pf.p.replaceCallback(pf, $(this));
        }
        pf.setHiddenElt();
        i += 3;
      });
      for (; i < matches.length - 1; i += 3) {
        this.mmList.addItem(false, matches[i + 2], matches[i + 1], '', '');
      }
    })
    .on('click', '.mmsr-plus', null, MMSR_plus_clicked)
    .on('click', '.mmsr-minus', null, MMSR_minus_clicked)
    .on('change', '#search-logic', null, MMSR_recalculate)
    .on('change', '#search-node-wheres,#search-page-wheres,#search-group-wheres', null, MMSR_where_changed)
    .on('change', '[name^="others_"]', null, function () {
      if (this.checked) {
        $('.mm-list-hidden:not([name=owner])', this.parentNode.parentNode.parentNode).each(function() {
          this.mmList.delAll();
        });
      }
      MMSR_recalculate();
    });

  $('#search-page-wheres,#search-group-wheres')
    .after('<div id="mmsr-where-list"></div>');
  MMSR_panels = [
    $('<table class="mmsr-cont-table"><tbody>'+
      '<tr class="mmsr-cont-row-widgets"><td colspan="2"><label>' + Drupal.t('of type') + ':</label></td></tr>' +
      '<tr class="mmsr-cont-row-widgets"><td colspan="2"></td></tr>' +
      '<tr class="mmsr-cont-row-widgets"><td colspan="2"><label>' + Drupal.t('where') + ':</label></td></tr>' +
      '<tr name="mmsr-cont-row" class="mmsr-cont-row"><td class="mmsr-where"></td><td class="mmsr-plus-minus" width="0"></td></tr>' +
      '<tr class="mmsr-cont-row-widgets"><td class="mmsr-widgets" colspan="2"></td></tr>' +
      '</tbody></table>'),
    $('<table class="mmsr-page-table"><tbody>' +
      '<tr class="mmsr-page-row-widgets"><td colspan="2"></td></tr>' +
      '<tr class="mmsr-page-row-widgets"><td colspan="2"><label>' + Drupal.t('where') + ':</label></td></tr>' +
      '<tr name="mmsr-page-row" class="mmsr-page-row"><td class="mmsr-where"></td><td class="mmsr-plus-minus" width="0"></td></tr>' +
      '<tr class="mmsr-page-row-widgets"><td class="mmsr-widgets" colspan="2"></td></tr>' +
      '</tbody></table>'),
    $('<table class="mmsr-group-table"><tbody>' +
      '<tr class="mmsr-group-row-widgets"><td colspan="2"></td></tr>' +
      '<tr class="mmsr-group-row-widgets"><td colspan="2"><label>' + Drupal.t('where') + ':</label></td></tr>' +
      '<tr name="mmsr-group-row" class="mmsr-group-row"><td class="mmsr-where"></td><td class="mmsr-plus-minus" width="0"></td></tr>' +
      '<tr class="mmsr-group-row-widgets"><td class="mmsr-widgets" colspan="2"></td></tr>' +
      '</tbody></table>')
  ];

  var minus = $('<input type="button" class="mmsr-minus" value="-" title="' + Drupal.t('Delete this row') + '" style="display: none">');
  var plus = $('<input type="button" class="mmsr-plus" title="' + Drupal.t('Add a row') + '" value="+">');
  var logic = $('#search-logic');

  // contents panel
  $('tr:first td:first', MMSR_panels[MMSR_CONTENTS_PANEL])
    .append($('#search-node-type'));
  $('.mmsr-where', MMSR_panels[MMSR_CONTENTS_PANEL])
    .append(logic)
    .append($('#search-node-wheres')
      .clone()
      .show());
  $('.mmsr-plus-minus', MMSR_panels[MMSR_CONTENTS_PANEL])
    .append(minus)
    .append(plus);

  // pages panel
  $('tr:first td:first', MMSR_panels[MMSR_PAGES_PANEL])
    .append($('#search-page-catlist'));
  $('.mmsr-where', MMSR_panels[MMSR_PAGES_PANEL])
    .append(logic.clone())
    .append($('#search-page-wheres')
      .clone()
      .show());
  $('.mmsr-plus-minus', MMSR_panels[MMSR_PAGES_PANEL])
    .append(minus.clone())
    .append(plus.clone());

  // groups panel
  $('tr:first td:first', MMSR_panels[MMSR_GROUPS_PANEL])
    .append($('#search-group-catlist'));
  $('.mmsr-where', MMSR_panels[MMSR_GROUPS_PANEL])
    .append(logic.clone())
    .append($('#search-group-wheres')
      .clone()
      .show());
  $('.mmsr-plus-minus', MMSR_panels[MMSR_GROUPS_PANEL])
    .append(minus.clone())
    .append(plus.clone());

  $('#search-actions')
    .before('<div id="mmsr-status" class="clearfix"><div id="mmsr-status-text"></div><div class="ajax-progress ajax-progress-throbber"><div class="throbber">&nbsp;&nbsp;</div></div></div>')
    .on('change', '[name=action_type]', null, function () { MMSR_recalculate_action(this); });
  $('<details id="mmsr-diagnostic" class="js-form-wrapper form-wrapper"><summary role="button" aria-controls="mmsr-diagnostic" aria-expanded="true" aria-pressed="true">' + Drupal.t('Query') + '</summary><div class="details-wrapper"><div id="mmsr-diagnostic-content"></div></div></details>')
    .add('#search-actions')
    .insertAfter('#mm-search-form');
  $('<input type="button" id="mmsr-recalc" value="' + Drupal.t('Recalc') + '">')
    .click(function () { MMSR_recalculate(true, {recalc: true}); })
    .prependTo('#mmsr-status');
  $('#mmsr-status #mmsr-status-text')
    .before(
      $('#edit-result')
        .click(function () {
          MMSR_serialize();
          return true;
        }))
    .before(
      $('#edit-reset')
        .click(function () {
          MMSR_init_done = false;
          $('input[type=button].mmsr-minus:gt(0)', MMSR_panels[MMSR_CONTENTS_PANEL])
            .click();
          $('input[type=button].mmsr-minus:gt(0)', MMSR_panels[MMSR_PAGES_PANEL])
            .click();
          $('input[type=button].mmsr-minus:gt(0)', MMSR_panels[MMSR_GROUPS_PANEL])
            .click();
          MMSR_import(drupalSettings.MM.MMSR.reset, document);
          MMSR_init_done = true;
          MMSR_recalculate();
          return false;
        }));

  // Remove empty legends because they add vertical space.
  $('#mm-search-form .fieldset-legend').each(function () { if (!$(this).text()) $(this).remove(); });
  MMSR_import(drupalSettings.MM.MMSR.startup, document);
  $("[name=search-page-cat]", MMSR_panels[MMSR_PAGES_PANEL])
    .val(drupalSettings.MM.MMSR.startup['search-page-cat'])
    .trigger('change');
  $("[name=search-group-cat]", MMSR_panels[MMSR_GROUPS_PANEL])
    .val(drupalSettings.MM.MMSR.startup['search-group-cat'])
    .trigger('change');
  $('#mmsr-where-list').on('change', 'input.mm-list-hidden', MMSR_recalculate);
  Drupal.behaviors.mmListInit = {attach: function() {}};
  MMSR_init_done = true;
  MMSR_recalculate();
};

var MMSR_fixupAutocomplete = function(obj) {
  $('input.mmsr-autocomplete:not(.subpanel-inited)', obj).each(function () {
    $(this).addClass('form-autocomplete').addClass('subpanel-inited');
    Drupal.behaviors.autocomplete.attach(this.parentNode);
  });
};

var MMSR_import = function (obj, where) {
  var MMSR_import_inner = function (obji, where) {
    if (typeof(obji) == 'object') {
      MMSR_import(obji, where);
    }
    else {
      $(where).val(where.name.slice(-2) === '[]' ? obji.split(',') : obji);
      if (where.tagName === 'SELECT' || where.tagName === 'INPUT') {
        $(where)
          .trigger('change')
          .trigger('mmsr-change');
      }
    }
  };

  var row, i;
  if (typeof(obj) == 'object')
    if (typeof(obj.length) == 'number') { // array
      for (i in obj) {
        if (obj.hasOwnProperty(i)) {
          row = where;
          if (i > 0) {
            $('.mmsr-plus:last', row)
              .trigger('click');
            row = row.nextSibling.nextSibling;
          }
          $(row)
            .each(
              function() {
                MMSR_import_inner(obj[i], this)
              });
        }
      }
    }
    else {
      for (i in obj) {
        if (obj.hasOwnProperty(i)) {
          row = where;
          if (row.tagName === 'TR' && i !== 'search-logic' && i !== 'search-node-wheres' && i !== 'search-page-wheres' && i !== 'search-group-wheres') {
            row = row.nextSibling;
          }
          $('[name="' + i + '"]:first', row)
            .each(
              function() {
                MMSR_import_inner(obj[i], this);
              });
        }
      }
    }
};

var MMSR_serialize = function (always) {
  if (MMSR_init_done) {
    var data = $($.merge($.merge(jQuery.makeArray(
      $("#edit-search-type,#mmsr-where-list table :input:not(:button):not(:submit):not([style='display: none']):not(.mmsr-ignore):not(.form-autocomplete[name$='-choose']):not([name=search-page-cat]):not([name=search-group-cat])")),
      $("[name=search-page-cat]", MMSR_panels[MMSR_PAGES_PANEL])),
      $("[name=search-group-cat]", MMSR_panels[MMSR_GROUPS_PANEL])))
      .mySerialize();
    if (always || data !== MMSR_last_recalc) {
      $('#edit-data')
        .val(data);
      MMSR_last_recalc = data;
      return data;
    }
  }
  return false;
};

MMSR_recalculate = function (adding, add, qp) {
  var data = MMSR_serialize(adding);
  function showStatus(msg) {
    $('#mmsr-status-text')
      .html(msg)
      .show()
      .next()
      .hide();
  }
  if (data) {
    $('#mmsr-status-text')
      .hide()
      .next()
      .show();
    $.ajax({
      type:     'POST',
      accepts:  {json: 'application/json', text_csv: 'text/csv'},
      dataType: 'text',
      data:     adding ? $.extend({ data: data }, add) : { data: data },
      url:      drupalSettings.MM.MMSR.get_path + (qp || ''),
      global:   false,
      success:  function (resp, a, xhr) {
                  switch (xhr.getResponseHeader('Content-Type').match(/\w+\/\w+/)[0]) {
                    case 'text/csv':
                      var blob = new Blob([resp], { type: 'text/csv' });
                      window.location = window.URL.createObjectURL(blob);
                      showStatus(Drupal.t('File downloaded.'));
                      break;

                    case 'application/json':
                      var obj = JSON.parse(resp);
                      var actions = $('#search-actions');
                      if (obj.hasOwnProperty('action_result_js') && window.hasOwnProperty(obj.action_result_js)) {
                        window[obj.action_result_js](obj, actions);
                      }
                      if (obj.hasOwnProperty('action_result')) {
                        var div = actions.find(obj.action_result_div);
                        if (obj.action_result) {
                          div.empty().show().append($(obj.action_result)).next().hide().parent().show();
                        }
                        else {
                          div.parent().hide();
                        }
                        $('#mmsr-status-text')
                          .show()
                          .next()
                          .hide();
                      }
                      else {
                        showStatus(obj.result || Drupal.t('An error occurred.'));
                        $('#mmsr-diagnostic-content')
                          .html(obj.query || '');
                        if (obj.actions.toString()) {
                          var type = actions.find('[name=action_type]').empty();
                          $.each(obj.actions, function(k, v) {
                            $('<option />')
                              .attr({value: k, selected: k === obj.action_selected})
                              .html(v)
                              .appendTo(type);
                          });
                          $('#action-config')
                            .empty()
                            .append(obj.form);
                          if (obj.hasOwnProperty('jsInit') && window.hasOwnProperty(obj.jsInit)) {
                            window[obj.jsInit](obj, actions);
                          }
                          actions.show();
                        }
                        else {
                          actions.hide();
                        }
                      }
                  }
                },
      error:    function () {
                  showStatus(Drupal.t('An error occurred.'));
                  $('#mmsr-diagnostic-content')
                    .html('');
                }
    });
  }
};

MMSR_recalculate_action = function (that, qp) {
  var add = {};
  $('#search-actions form input:not(.form-submit):not(:button):not([name$="-choose"]),#search-actions form select,#search-actions form textarea')
    .add(that)
    .each(function () {
      if (this.name && (this.type !== 'checkbox' || this.checked)) {
        add[this.name] = this.value;
      }
    });
  $('#mmsr-mp-status-text')
    .hide()
    .next()
    .show();
  MMSR_recalculate(true, add, qp);
}

var initCatlists = function (jsonobj, actions) {
  $.each(jsonobj.drupalSettings.MM.mmListInit, function(key, instance) {
    if (instance) {
      // Clone parms so that changes at lower levels don't affect other instances.
      instance.parms = jQuery.extend(true, {}, instance.parms);
      instance.parms.isSearch = true;   // prevent "required"
      var obj = Drupal.mmListGetObj(actions, instance);
      if (obj) {
        $.each(instance.add, function(key, list) {
          list.unshift(false);
          obj.addItem.apply(obj, list);
        });
        obj.enableOpts();
        $('details', instance.parms.outerDiv).each(function() {
          obj.addAutocomplete.apply(obj, $(this));
        })
      }
    }
  });
};

MMSR_init_action_pager = function () {
  $('#action-config .pager__items a, table th a')
    .click(function () {
      MMSR_recalculate_action(null, (new URL($(this).attr('href'), location)).search);
      return false;
    });
};

MMSR_init_action_modify_perms = function (jsonobj, actions) {
  initCatlists(jsonobj, actions);
  actions
    .find('input,select').change(function() {
      actions.find('#mmsr-mp-status-text,#mmsr-mp-status .ajax-progress,#edit-mp-result').hide();
    })
    .end()
    .find('#edit-modify-mode').change(function () {
      var val = $(this).val();
      actions
        .find('.form-item-modify-users-w,.form-item-modify-groups-w')
          .toggle(val !== 'owner')
        .end()
        .find('.form-item-modify-mp-mode')
          .toggle(val === 'add_ug')
        .end()
        .find('.form-item-modify-owner-userlist')
          .toggle(val === 'owner');
    })
    .change();
};

MMSR_action_modify_perms_update = function (jsonobj, actions) {
  actions.find('#edit-mp-result').toggle(!!jsonobj.mp_enable);
};

MMSR_init_action_clean_perms = function (jsonobj, actions) {
  actions.find('#mmsr-mp-status-text,#mmsr-mp-status .ajax-progress,#edit-mp-result').hide();
};

MMSR_init_action_replace_text = function (jsonobj, actions) {
  function testRegex() {
    var desc = actions.find('#edit-from--description').hide();
    if (actions.find('#edit-method').val() === 'regex') {
      try {
        new RegExp(actions.find('#edit-from').val());
      }
      catch (e) {
        desc.text(Drupal.t('Syntax error in regular expression: @err', {'@err': e.message})).show();
      }
    }
  }
  actions
    .find('input,select').change(function() {
      actions.find('#mmsr-mp-status-text,#mmsr-mp-status .ajax-progress,#edit-mp-result').hide();
    })
    .end()
    .find('#edit-method').change(function () {
      var val = $(this).val();
      actions.find('#edit-to--description').toggle(val === 'regex');
      testRegex();
    })
    .change()
    .end()
    .find('#edit-from').change(testRegex);
};

MMSR_init_action_modify_pages = function (jsonobj, actions) {
  initCatlists(jsonobj, actions);
  actions
    .find('input,select').change(function() {
      actions.find('#mmsr-mp-status-text,#mmsr-mp-status .ajax-progress,#edit-mp-result').hide();
    })
    .end()
    .find('#edit-modify-mode').change(function () {
      actions
        .find('#edit-repl-catlist')
        .toggle($(this).val() === 'repl_pgs');
    })
    .change();
}

MMSR_onchange_flags = function (obj, name) {
  $('[name="' + name + '"]', obj.parentNode.parentNode).toggle(obj.value < 10);
  return true;
};

MMSR_onchange_node_types = function (obj) {
  $('[name="allowed_node_types[]"]', obj.parentNode.parentNode).toggle(obj.value !== 2 && obj.value !== 5);
  return true;
};

Drupal.behaviors.MMSR_initialize = {
  attach: function() {
    Drupal.autocomplete.options.select = function(event, ui) {
      event.target.value = ui.item.label;
      return false;
    };

    MMSR_initialize();
  }
};

// Prevent automatic addition of autocomplete handlers in MMLists.
$('div[name^=mm_list_obj] input.form-autocomplete').addClass('mmsr-autocomplete-mmlist').removeClass('form-autocomplete');
// Prevent automatic addition of autocomplete handlers in other things.
$('input.form-autocomplete').addClass('mmsr-autocomplete').removeClass('form-autocomplete');

})(jQuery, Drupal, drupalSettings);
