(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.MMShowGroup = {
    attach: function () {
      var initialResize = 0;
      var obj = $('#mm-user-datatable-members-display');
      obj.DataTable({
        columns:      obj.data('col-def'),
        processing:   true,
        serverSide:   true,
        pageLength:   20,
        lengthChange: false,
        ajax:         { url: obj.data('link-location') },
        language:     {
          infoFiltered: Drupal.t('(filtered from _MAX_)'),
          entries: {
            _: 'users',
            1: 'user'
          }
        },
        drawCallback: function() {
          if (!initialResize++ && typeof parent.Drupal.mmDialogResized === 'function') {
            parent.Drupal.mmDialogResized(document.body.scrollWidth, document.body.scrollHeight);
          }
        }
      });
    }
  };
})(jQuery, Drupal, drupalSettings);