<?php
/**
 * @file
 * Contains \Drupal\mm_fields\Plugin\Field\FieldFormatter\MMFieldsUser.
 */

namespace Drupal\mm_fields\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * @FieldFormatter(
 *  id = "mm_fields_user",
 *  label = @Translation("User"),
 *  field_types = {"mm_userlist"}
 * )
 */
class MMFieldsUser extends FormatterBase {

  /**
   * @inheritDoc
   * @return mixed[]
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => mm_content_uid2name($item->value, 'fmlu')];
    }
    return $elements;
  }

}
