import { Widget } from 'ckeditor5/src/widget';
import InsertMMMediaLibraryCommand from './insertMMMediaLibraryCommand';
import DrupalMediaEditing
  from "../../../../../../../../../core/modules/ckeditor5/js/ckeditor5_plugins/drupalMedia/src/drupalmediaediting";

export default class MMMediaLibraryEditing extends DrupalMediaEditing {
  static get requires() {
    return [Widget];
  }

  init() {
    const options = this.editor.config.get('MMMediaLibrary');
    if (!options) {
      return;
    }
    const { previewURL, themeError } = options;
    this.previewUrl = previewURL;
    this.labelError = Drupal.t('Preview failed');
    this.themeError =
      themeError ||
      `
      <p>${Drupal.t(
        'An error occurred while trying to preview the media. Please save your work and reload this page.',
      )}<p>
    `;

    this.editor.commands.add(
      'insertMMMediaLibrary',
      new InsertMMMediaLibraryCommand(this.editor),
    );
  }

  static get pluginName() {
    return 'MMMediaLibraryEditing';
  }
}
